@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes what transforms are applied before matching
 */
public enum class Transform(
    public val javaValue: com.pulumi.azurenative.network.enums.Transform,
) : ConvertibleToJava<com.pulumi.azurenative.network.enums.Transform> {
    Lowercase(com.pulumi.azurenative.network.enums.Transform.Lowercase),
    Uppercase(com.pulumi.azurenative.network.enums.Transform.Uppercase),
    Trim(com.pulumi.azurenative.network.enums.Transform.Trim),
    UrlDecode(com.pulumi.azurenative.network.enums.Transform.UrlDecode),
    UrlEncode(com.pulumi.azurenative.network.enums.Transform.UrlEncode),
    RemoveNulls(com.pulumi.azurenative.network.enums.Transform.RemoveNulls),
    ;

    override fun toJava(): com.pulumi.azurenative.network.enums.Transform = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.enums.Transform): Transform =
            Transform.values().first { it.javaValue == javaType }
    }
}
