@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AadAuthenticationParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AAD Vpn authentication type related parameters.
 * @property aadAudience AAD Vpn authentication parameter AAD audience.
 * @property aadIssuer AAD Vpn authentication parameter AAD issuer.
 * @property aadTenant AAD Vpn authentication parameter AAD tenant.
 */
public data class AadAuthenticationParametersArgs(
    public val aadAudience: Output<String>? = null,
    public val aadIssuer: Output<String>? = null,
    public val aadTenant: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AadAuthenticationParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AadAuthenticationParametersArgs =
        com.pulumi.azurenative.network.inputs.AadAuthenticationParametersArgs.builder()
            .aadAudience(aadAudience?.applyValue({ args0 -> args0 }))
            .aadIssuer(aadIssuer?.applyValue({ args0 -> args0 }))
            .aadTenant(aadTenant?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AadAuthenticationParametersArgs].
 */
@PulumiTagMarker
public class AadAuthenticationParametersArgsBuilder internal constructor() {
    private var aadAudience: Output<String>? = null

    private var aadIssuer: Output<String>? = null

    private var aadTenant: Output<String>? = null

    /**
     * @param value AAD Vpn authentication parameter AAD audience.
     */
    @JvmName("xbaadgsihnhtldbg")
    public suspend fun aadAudience(`value`: Output<String>) {
        this.aadAudience = value
    }

    /**
     * @param value AAD Vpn authentication parameter AAD issuer.
     */
    @JvmName("qrwvnqpmpcmolkpa")
    public suspend fun aadIssuer(`value`: Output<String>) {
        this.aadIssuer = value
    }

    /**
     * @param value AAD Vpn authentication parameter AAD tenant.
     */
    @JvmName("vhyhywsevxlskjcu")
    public suspend fun aadTenant(`value`: Output<String>) {
        this.aadTenant = value
    }

    /**
     * @param value AAD Vpn authentication parameter AAD audience.
     */
    @JvmName("ugxmtppwapwixdbm")
    public suspend fun aadAudience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadAudience = mapped
    }

    /**
     * @param value AAD Vpn authentication parameter AAD issuer.
     */
    @JvmName("rlbauossqvjpdiyg")
    public suspend fun aadIssuer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadIssuer = mapped
    }

    /**
     * @param value AAD Vpn authentication parameter AAD tenant.
     */
    @JvmName("ebctwryfgfdxbopd")
    public suspend fun aadTenant(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadTenant = mapped
    }

    internal fun build(): AadAuthenticationParametersArgs = AadAuthenticationParametersArgs(
        aadAudience = aadAudience,
        aadIssuer = aadIssuer,
        aadTenant = aadTenant,
    )
}
