@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayIPConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * IP configuration of an application gateway. Currently 1 public and 1 private IP configuration is allowed.
 * @property id Resource ID.
 * @property name Name of the IP configuration that is unique within an Application Gateway.
 * @property subnet Reference to the subnet resource. A subnet from where application gateway gets its private address.
 */
public data class ApplicationGatewayIPConfigurationArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subnet: Output<SubResourceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayIPConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayIPConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayIPConfigurationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subnet(subnet?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApplicationGatewayIPConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayIPConfigurationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var subnet: Output<SubResourceArgs>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("tagmhsrpqgmihtkw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the IP configuration that is unique within an Application Gateway.
     */
    @JvmName("pknwmmnbyquhiwer")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Reference to the subnet resource. A subnet from where application gateway gets its private address.
     */
    @JvmName("ogvejfmuojybsnkt")
    public suspend fun subnet(`value`: Output<SubResourceArgs>) {
        this.subnet = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("mdlxcwvpxjuonyko")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the IP configuration that is unique within an Application Gateway.
     */
    @JvmName("apxhxhskveitojel")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Reference to the subnet resource. A subnet from where application gateway gets its private address.
     */
    @JvmName("akycgyuenpnteame")
    public suspend fun subnet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnet = mapped
    }

    /**
     * @param argument Reference to the subnet resource. A subnet from where application gateway gets its private address.
     */
    @JvmName("aehpumiuqibbrckg")
    public suspend fun subnet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.subnet = mapped
    }

    internal fun build(): ApplicationGatewayIPConfigurationArgs =
        ApplicationGatewayIPConfigurationArgs(
            id = id,
            name = name,
            subnet = subnet,
        )
}
