@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeHealthResponseMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Application gateway probe health response match.
 * @property body Body that must be contained in the health response. Default value is empty.
 * @property statusCodes Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
 */
public data class ApplicationGatewayProbeHealthResponseMatchArgs(
    public val body: Output<String>? = null,
    public val statusCodes: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeHealthResponseMatchArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeHealthResponseMatchArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayProbeHealthResponseMatchArgs.builder()
            .body(body?.applyValue({ args0 -> args0 }))
            .statusCodes(statusCodes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ApplicationGatewayProbeHealthResponseMatchArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayProbeHealthResponseMatchArgsBuilder internal constructor() {
    private var body: Output<String>? = null

    private var statusCodes: Output<List<String>>? = null

    /**
     * @param value Body that must be contained in the health response. Default value is empty.
     */
    @JvmName("ilougwirbmdehccc")
    public suspend fun body(`value`: Output<String>) {
        this.body = value
    }

    /**
     * @param value Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
     */
    @JvmName("lomaqtxfjwkoorca")
    public suspend fun statusCodes(`value`: Output<List<String>>) {
        this.statusCodes = value
    }

    @JvmName("faxfqyuvepakimeu")
    public suspend fun statusCodes(vararg values: Output<String>) {
        this.statusCodes = Output.all(values.asList())
    }

    /**
     * @param values Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
     */
    @JvmName("bifxaqwxkqwxspev")
    public suspend fun statusCodes(values: List<Output<String>>) {
        this.statusCodes = Output.all(values)
    }

    /**
     * @param value Body that must be contained in the health response. Default value is empty.
     */
    @JvmName("qlbjdvmgiqcfprot")
    public suspend fun body(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
     */
    @JvmName("jekuoelvevsyevrc")
    public suspend fun statusCodes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statusCodes = mapped
    }

    /**
     * @param values Allowed ranges of healthy status codes. Default range of healthy status codes is 200-399.
     */
    @JvmName("garfcefylfgyyawk")
    public suspend fun statusCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statusCodes = mapped
    }

    internal fun build(): ApplicationGatewayProbeHealthResponseMatchArgs =
        ApplicationGatewayProbeHealthResponseMatchArgs(
            body = body,
            statusCodes = statusCodes,
        )
}
