@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleActionSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Set of actions in the Rewrite Rule in Application Gateway.
 * @property requestHeaderConfigurations Request Header Actions in the Action Set.
 * @property responseHeaderConfigurations Response Header Actions in the Action Set.
 * @property urlConfiguration Url Configuration Action in the Action Set.
 */
public data class ApplicationGatewayRewriteRuleActionSetArgs(
    public val requestHeaderConfigurations: Output<List<ApplicationGatewayHeaderConfigurationArgs>>? =
        null,
    public val responseHeaderConfigurations: Output<List<ApplicationGatewayHeaderConfigurationArgs>>? =
        null,
    public val urlConfiguration: Output<ApplicationGatewayUrlConfigurationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleActionSetArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleActionSetArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleActionSetArgs.builder()
            .requestHeaderConfigurations(
                requestHeaderConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .responseHeaderConfigurations(
                responseHeaderConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .urlConfiguration(
                urlConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewayRewriteRuleActionSetArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayRewriteRuleActionSetArgsBuilder internal constructor() {
    private var requestHeaderConfigurations: Output<List<ApplicationGatewayHeaderConfigurationArgs>>? =
        null

    private var responseHeaderConfigurations: Output<List<ApplicationGatewayHeaderConfigurationArgs>>? =
        null

    private var urlConfiguration: Output<ApplicationGatewayUrlConfigurationArgs>? = null

    /**
     * @param value Request Header Actions in the Action Set.
     */
    @JvmName("lyagqmvlvayewsnj")
    public suspend
    fun requestHeaderConfigurations(`value`: Output<List<ApplicationGatewayHeaderConfigurationArgs>>) {
        this.requestHeaderConfigurations = value
    }

    @JvmName("eppfugmevdxjsspg")
    public suspend fun requestHeaderConfigurations(
        vararg
        values: Output<ApplicationGatewayHeaderConfigurationArgs>,
    ) {
        this.requestHeaderConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Request Header Actions in the Action Set.
     */
    @JvmName("tktpwjlbnoovumco")
    public suspend
    fun requestHeaderConfigurations(values: List<Output<ApplicationGatewayHeaderConfigurationArgs>>) {
        this.requestHeaderConfigurations = Output.all(values)
    }

    /**
     * @param value Response Header Actions in the Action Set.
     */
    @JvmName("wslauyuirbdbyigm")
    public suspend
    fun responseHeaderConfigurations(`value`: Output<List<ApplicationGatewayHeaderConfigurationArgs>>) {
        this.responseHeaderConfigurations = value
    }

    @JvmName("lanamxvbyusombsn")
    public suspend fun responseHeaderConfigurations(
        vararg
        values: Output<ApplicationGatewayHeaderConfigurationArgs>,
    ) {
        this.responseHeaderConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Response Header Actions in the Action Set.
     */
    @JvmName("syjjhsjrcrcsbeys")
    public suspend
    fun responseHeaderConfigurations(values: List<Output<ApplicationGatewayHeaderConfigurationArgs>>) {
        this.responseHeaderConfigurations = Output.all(values)
    }

    /**
     * @param value Url Configuration Action in the Action Set.
     */
    @JvmName("fqlnvlabcninbfhx")
    public suspend fun urlConfiguration(`value`: Output<ApplicationGatewayUrlConfigurationArgs>) {
        this.urlConfiguration = value
    }

    /**
     * @param value Request Header Actions in the Action Set.
     */
    @JvmName("quuleehbokxamqmp")
    public suspend
    fun requestHeaderConfigurations(`value`: List<ApplicationGatewayHeaderConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestHeaderConfigurations = mapped
    }

    /**
     * @param argument Request Header Actions in the Action Set.
     */
    @JvmName("hpopbdncinfneloq")
    public suspend
    fun requestHeaderConfigurations(argument: List<suspend ApplicationGatewayHeaderConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayHeaderConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.requestHeaderConfigurations = mapped
    }

    /**
     * @param argument Request Header Actions in the Action Set.
     */
    @JvmName("enxudqecvvcitkkc")
    public suspend fun requestHeaderConfigurations(
        vararg
        argument: suspend ApplicationGatewayHeaderConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayHeaderConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.requestHeaderConfigurations = mapped
    }

    /**
     * @param argument Request Header Actions in the Action Set.
     */
    @JvmName("prwlxfewyocsfyfy")
    public suspend
    fun requestHeaderConfigurations(argument: suspend ApplicationGatewayHeaderConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayHeaderConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.requestHeaderConfigurations = mapped
    }

    /**
     * @param values Request Header Actions in the Action Set.
     */
    @JvmName("wiebbahjjeftswys")
    public suspend fun requestHeaderConfigurations(
        vararg
        values: ApplicationGatewayHeaderConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestHeaderConfigurations = mapped
    }

    /**
     * @param value Response Header Actions in the Action Set.
     */
    @JvmName("hfpdkjwnpjeeyruu")
    public suspend
    fun responseHeaderConfigurations(`value`: List<ApplicationGatewayHeaderConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseHeaderConfigurations = mapped
    }

    /**
     * @param argument Response Header Actions in the Action Set.
     */
    @JvmName("ktcdcjopejlikqhb")
    public suspend
    fun responseHeaderConfigurations(argument: List<suspend ApplicationGatewayHeaderConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayHeaderConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaderConfigurations = mapped
    }

    /**
     * @param argument Response Header Actions in the Action Set.
     */
    @JvmName("elbybmamqibfjmks")
    public suspend fun responseHeaderConfigurations(
        vararg
        argument: suspend ApplicationGatewayHeaderConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayHeaderConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaderConfigurations = mapped
    }

    /**
     * @param argument Response Header Actions in the Action Set.
     */
    @JvmName("slpcrvxfjdgidgbg")
    public suspend
    fun responseHeaderConfigurations(argument: suspend ApplicationGatewayHeaderConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayHeaderConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.responseHeaderConfigurations = mapped
    }

    /**
     * @param values Response Header Actions in the Action Set.
     */
    @JvmName("gfmmqshfkajjvtqr")
    public suspend fun responseHeaderConfigurations(
        vararg
        values: ApplicationGatewayHeaderConfigurationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseHeaderConfigurations = mapped
    }

    /**
     * @param value Url Configuration Action in the Action Set.
     */
    @JvmName("jqgpbqgpqicwjiof")
    public suspend fun urlConfiguration(`value`: ApplicationGatewayUrlConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.urlConfiguration = mapped
    }

    /**
     * @param argument Url Configuration Action in the Action Set.
     */
    @JvmName("bmamgbkyllapsvjq")
    public suspend
    fun urlConfiguration(argument: suspend ApplicationGatewayUrlConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationGatewayUrlConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.urlConfiguration = mapped
    }

    internal fun build(): ApplicationGatewayRewriteRuleActionSetArgs =
        ApplicationGatewayRewriteRuleActionSetArgs(
            requestHeaderConfigurations = requestHeaderConfigurations,
            responseHeaderConfigurations = responseHeaderConfigurations,
            urlConfiguration = urlConfiguration,
        )
}
