@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Rewrite rule set of an application gateway.
 * @property id Resource ID.
 * @property name Name of the rewrite rule set that is unique within an Application Gateway.
 * @property rewriteRules Rewrite rules in the rewrite rule set.
 */
public data class ApplicationGatewayRewriteRuleSetArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val rewriteRules: Output<List<ApplicationGatewayRewriteRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleSetArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayRewriteRuleSetArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .rewriteRules(
                rewriteRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewayRewriteRuleSetArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayRewriteRuleSetArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var rewriteRules: Output<List<ApplicationGatewayRewriteRuleArgs>>? = null

    /**
     * @param value Resource ID.
     */
    @JvmName("isetqowuwqyupgux")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the rewrite rule set that is unique within an Application Gateway.
     */
    @JvmName("xorxbthqkouhcxox")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Rewrite rules in the rewrite rule set.
     */
    @JvmName("hwitfswqfxuicrwq")
    public suspend fun rewriteRules(`value`: Output<List<ApplicationGatewayRewriteRuleArgs>>) {
        this.rewriteRules = value
    }

    @JvmName("vvirhaovuecumyde")
    public suspend fun rewriteRules(vararg values: Output<ApplicationGatewayRewriteRuleArgs>) {
        this.rewriteRules = Output.all(values.asList())
    }

    /**
     * @param values Rewrite rules in the rewrite rule set.
     */
    @JvmName("dyvoihbxnjbqcbsb")
    public suspend fun rewriteRules(values: List<Output<ApplicationGatewayRewriteRuleArgs>>) {
        this.rewriteRules = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("jnbcwqguoswusnwp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the rewrite rule set that is unique within an Application Gateway.
     */
    @JvmName("lqogbcxjrithbycb")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Rewrite rules in the rewrite rule set.
     */
    @JvmName("ifypfuoylymwkeeg")
    public suspend fun rewriteRules(`value`: List<ApplicationGatewayRewriteRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rewriteRules = mapped
    }

    /**
     * @param argument Rewrite rules in the rewrite rule set.
     */
    @JvmName("qwwbqqbuhpixsgjv")
    public suspend
    fun rewriteRules(argument: List<suspend ApplicationGatewayRewriteRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRewriteRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rewriteRules = mapped
    }

    /**
     * @param argument Rewrite rules in the rewrite rule set.
     */
    @JvmName("btmuyjaoaebnabbq")
    public suspend fun rewriteRules(
        vararg
        argument: suspend ApplicationGatewayRewriteRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayRewriteRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rewriteRules = mapped
    }

    /**
     * @param argument Rewrite rules in the rewrite rule set.
     */
    @JvmName("ualcaetaboevsuff")
    public suspend
    fun rewriteRules(argument: suspend ApplicationGatewayRewriteRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayRewriteRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rewriteRules = mapped
    }

    /**
     * @param values Rewrite rules in the rewrite rule set.
     */
    @JvmName("aigcujxkmwyohaba")
    public suspend fun rewriteRules(vararg values: ApplicationGatewayRewriteRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rewriteRules = mapped
    }

    internal fun build(): ApplicationGatewayRewriteRuleSetArgs = ApplicationGatewayRewriteRuleSetArgs(
        id = id,
        name = name,
        rewriteRules = rewriteRules,
    )
}
