@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewaySslPolicyArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewaySslCipherSuite
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewaySslPolicyName
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewaySslPolicyType
import com.pulumi.azurenative.network.kotlin.enums.ApplicationGatewaySslProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Application Gateway Ssl policy.
 * @property cipherSuites Ssl cipher suites to be enabled in the specified order to application gateway.
 * @property disabledSslProtocols Ssl protocols to be disabled on application gateway.
 * @property minProtocolVersion Minimum version of Ssl protocol to be supported on application gateway.
 * @property policyName Name of Ssl predefined policy.
 * @property policyType Type of Ssl Policy.
 */
public data class ApplicationGatewaySslPolicyArgs(
    public val cipherSuites: Output<List<Either<String, ApplicationGatewaySslCipherSuite>>>? = null,
    public val disabledSslProtocols: Output<List<Either<String, ApplicationGatewaySslProtocol>>>? =
        null,
    public val minProtocolVersion: Output<Either<String, ApplicationGatewaySslProtocol>>? = null,
    public val policyName: Output<Either<String, ApplicationGatewaySslPolicyName>>? = null,
    public val policyType: Output<Either<String, ApplicationGatewaySslPolicyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewaySslPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewaySslPolicyArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewaySslPolicyArgs.builder()
            .cipherSuites(
                cipherSuites?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .disabledSslProtocols(
                disabledSslProtocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .minProtocolVersion(
                minProtocolVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policyName(
                policyName?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewaySslPolicyArgs].
 */
@PulumiTagMarker
public class ApplicationGatewaySslPolicyArgsBuilder internal constructor() {
    private var cipherSuites: Output<List<Either<String, ApplicationGatewaySslCipherSuite>>>? = null

    private var disabledSslProtocols: Output<List<Either<String, ApplicationGatewaySslProtocol>>>? =
        null

    private var minProtocolVersion: Output<Either<String, ApplicationGatewaySslProtocol>>? = null

    private var policyName: Output<Either<String, ApplicationGatewaySslPolicyName>>? = null

    private var policyType: Output<Either<String, ApplicationGatewaySslPolicyType>>? = null

    /**
     * @param value Ssl cipher suites to be enabled in the specified order to application gateway.
     */
    @JvmName("xsbqdeudlfnxicgg")
    public suspend
    fun cipherSuites(`value`: Output<List<Either<String, ApplicationGatewaySslCipherSuite>>>) {
        this.cipherSuites = value
    }

    @JvmName("fvuxofenfexxrxlc")
    public suspend fun cipherSuites(
        vararg
        values: Output<Either<String, ApplicationGatewaySslCipherSuite>>,
    ) {
        this.cipherSuites = Output.all(values.asList())
    }

    /**
     * @param values Ssl cipher suites to be enabled in the specified order to application gateway.
     */
    @JvmName("ktcyhskihsrqojro")
    public suspend
    fun cipherSuites(values: List<Output<Either<String, ApplicationGatewaySslCipherSuite>>>) {
        this.cipherSuites = Output.all(values)
    }

    /**
     * @param value Ssl protocols to be disabled on application gateway.
     */
    @JvmName("skxilkosodcpmxyh")
    public suspend
    fun disabledSslProtocols(`value`: Output<List<Either<String, ApplicationGatewaySslProtocol>>>) {
        this.disabledSslProtocols = value
    }

    @JvmName("nagborbmfydtppbd")
    public suspend fun disabledSslProtocols(
        vararg
        values: Output<Either<String, ApplicationGatewaySslProtocol>>,
    ) {
        this.disabledSslProtocols = Output.all(values.asList())
    }

    /**
     * @param values Ssl protocols to be disabled on application gateway.
     */
    @JvmName("mmvsotviewovkljf")
    public suspend
    fun disabledSslProtocols(values: List<Output<Either<String, ApplicationGatewaySslProtocol>>>) {
        this.disabledSslProtocols = Output.all(values)
    }

    /**
     * @param value Minimum version of Ssl protocol to be supported on application gateway.
     */
    @JvmName("eywknvywwfxouieq")
    public suspend
    fun minProtocolVersion(`value`: Output<Either<String, ApplicationGatewaySslProtocol>>) {
        this.minProtocolVersion = value
    }

    /**
     * @param value Name of Ssl predefined policy.
     */
    @JvmName("rsfkhqoqbwaojcki")
    public suspend fun policyName(`value`: Output<Either<String, ApplicationGatewaySslPolicyName>>) {
        this.policyName = value
    }

    /**
     * @param value Type of Ssl Policy.
     */
    @JvmName("uqxbekalbkfmyklm")
    public suspend fun policyType(`value`: Output<Either<String, ApplicationGatewaySslPolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value Ssl cipher suites to be enabled in the specified order to application gateway.
     */
    @JvmName("ekwbtssgrwtefslv")
    public suspend
    fun cipherSuites(`value`: List<Either<String, ApplicationGatewaySslCipherSuite>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cipherSuites = mapped
    }

    /**
     * @param values Ssl cipher suites to be enabled in the specified order to application gateway.
     */
    @JvmName("fmghmcwrsljmuanw")
    public suspend fun cipherSuites(vararg values: Either<String, ApplicationGatewaySslCipherSuite>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cipherSuites = mapped
    }

    /**
     * @param value Ssl protocols to be disabled on application gateway.
     */
    @JvmName("gqingkopkwhttwen")
    public suspend
    fun disabledSslProtocols(`value`: List<Either<String, ApplicationGatewaySslProtocol>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabledSslProtocols = mapped
    }

    /**
     * @param values Ssl protocols to be disabled on application gateway.
     */
    @JvmName("jcxavlfwtmjebdrk")
    public suspend fun disabledSslProtocols(
        vararg
        values: Either<String, ApplicationGatewaySslProtocol>,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disabledSslProtocols = mapped
    }

    /**
     * @param value Minimum version of Ssl protocol to be supported on application gateway.
     */
    @JvmName("hewcmoflaiibefhs")
    public suspend fun minProtocolVersion(`value`: Either<String, ApplicationGatewaySslProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minProtocolVersion = mapped
    }

    /**
     * @param value Minimum version of Ssl protocol to be supported on application gateway.
     */
    @JvmName("ottfbluuxaphjkya")
    public fun minProtocolVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewaySslProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minProtocolVersion = mapped
    }

    /**
     * @param value Minimum version of Ssl protocol to be supported on application gateway.
     */
    @JvmName("cmtdhrdokdhtawma")
    public fun minProtocolVersion(`value`: ApplicationGatewaySslProtocol) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewaySslProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minProtocolVersion = mapped
    }

    /**
     * @param value Name of Ssl predefined policy.
     */
    @JvmName("jkeyplmuxuivkuxo")
    public suspend fun policyName(`value`: Either<String, ApplicationGatewaySslPolicyName>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Name of Ssl predefined policy.
     */
    @JvmName("mjxfpycvfoxwfnql")
    public fun policyName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewaySslPolicyName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Name of Ssl predefined policy.
     */
    @JvmName("bchwrsbbpfxtlhcl")
    public fun policyName(`value`: ApplicationGatewaySslPolicyName) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewaySslPolicyName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Type of Ssl Policy.
     */
    @JvmName("kyicfxfxatetcnph")
    public suspend fun policyType(`value`: Either<String, ApplicationGatewaySslPolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Type of Ssl Policy.
     */
    @JvmName("cedqacesxvcccqdx")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGatewaySslPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value Type of Ssl Policy.
     */
    @JvmName("kndandxqsfukqapy")
    public fun policyType(`value`: ApplicationGatewaySslPolicyType) {
        val toBeMapped = Either.ofRight<String, ApplicationGatewaySslPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    internal fun build(): ApplicationGatewaySslPolicyArgs = ApplicationGatewaySslPolicyArgs(
        cipherSuites = cipherSuites,
        disabledSslProtocols = disabledSslProtocols,
        minProtocolVersion = minProtocolVersion,
        policyName = policyName,
        policyType = policyType,
    )
}
