@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayTrustedRootCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Trusted Root certificates of an application gateway.
 * @property data Certificate public data.
 * @property id Resource ID.
 * @property keyVaultSecretId Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
 * @property name Name of the trusted root certificate that is unique within an Application Gateway.
 */
public data class ApplicationGatewayTrustedRootCertificateArgs(
    public val `data`: Output<String>? = null,
    public val id: Output<String>? = null,
    public val keyVaultSecretId: Output<String>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayTrustedRootCertificateArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ApplicationGatewayTrustedRootCertificateArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayTrustedRootCertificateArgs.builder()
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .keyVaultSecretId(keyVaultSecretId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationGatewayTrustedRootCertificateArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayTrustedRootCertificateArgsBuilder internal constructor() {
    private var `data`: Output<String>? = null

    private var id: Output<String>? = null

    private var keyVaultSecretId: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Certificate public data.
     */
    @JvmName("dmblepafyujgeaic")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gkipkicykkbnqoqe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
     */
    @JvmName("vnvjjvownbdwrhxc")
    public suspend fun keyVaultSecretId(`value`: Output<String>) {
        this.keyVaultSecretId = value
    }

    /**
     * @param value Name of the trusted root certificate that is unique within an Application Gateway.
     */
    @JvmName("txcwmenrkdsuxlri")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Certificate public data.
     */
    @JvmName("lbqokleuwrohyvtn")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ypdxybpegfberdjd")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
     */
    @JvmName("pvflanqipurofxcn")
    public suspend fun keyVaultSecretId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultSecretId = mapped
    }

    /**
     * @param value Name of the trusted root certificate that is unique within an Application Gateway.
     */
    @JvmName("xxvnfmapcbaegnnp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ApplicationGatewayTrustedRootCertificateArgs =
        ApplicationGatewayTrustedRootCertificateArgs(
            `data` = `data`,
            id = id,
            keyVaultSecretId = keyVaultSecretId,
            name = name,
        )
}
