@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ApplicationGatewayUrlPathMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.
 * @property defaultBackendAddressPool Default backend address pool resource of URL path map.
 * @property defaultBackendHttpSettings Default backend http settings resource of URL path map.
 * @property defaultLoadDistributionPolicy Default Load Distribution Policy resource of URL path map.
 * @property defaultRedirectConfiguration Default redirect configuration resource of URL path map.
 * @property defaultRewriteRuleSet Default Rewrite rule set resource of URL path map.
 * @property id Resource ID.
 * @property name Name of the URL path map that is unique within an Application Gateway.
 * @property pathRules Path rule of URL path map resource.
 */
public data class ApplicationGatewayUrlPathMapArgs(
    public val defaultBackendAddressPool: Output<SubResourceArgs>? = null,
    public val defaultBackendHttpSettings: Output<SubResourceArgs>? = null,
    public val defaultLoadDistributionPolicy: Output<SubResourceArgs>? = null,
    public val defaultRedirectConfiguration: Output<SubResourceArgs>? = null,
    public val defaultRewriteRuleSet: Output<SubResourceArgs>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val pathRules: Output<List<ApplicationGatewayPathRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ApplicationGatewayUrlPathMapArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ApplicationGatewayUrlPathMapArgs =
        com.pulumi.azurenative.network.inputs.ApplicationGatewayUrlPathMapArgs.builder()
            .defaultBackendAddressPool(
                defaultBackendAddressPool?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultBackendHttpSettings(
                defaultBackendHttpSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultLoadDistributionPolicy(
                defaultLoadDistributionPolicy?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .defaultRedirectConfiguration(
                defaultRedirectConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .defaultRewriteRuleSet(
                defaultRewriteRuleSet?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .pathRules(
                pathRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationGatewayUrlPathMapArgs].
 */
@PulumiTagMarker
public class ApplicationGatewayUrlPathMapArgsBuilder internal constructor() {
    private var defaultBackendAddressPool: Output<SubResourceArgs>? = null

    private var defaultBackendHttpSettings: Output<SubResourceArgs>? = null

    private var defaultLoadDistributionPolicy: Output<SubResourceArgs>? = null

    private var defaultRedirectConfiguration: Output<SubResourceArgs>? = null

    private var defaultRewriteRuleSet: Output<SubResourceArgs>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var pathRules: Output<List<ApplicationGatewayPathRuleArgs>>? = null

    /**
     * @param value Default backend address pool resource of URL path map.
     */
    @JvmName("vrbeayvwhcadslwj")
    public suspend fun defaultBackendAddressPool(`value`: Output<SubResourceArgs>) {
        this.defaultBackendAddressPool = value
    }

    /**
     * @param value Default backend http settings resource of URL path map.
     */
    @JvmName("qcrmcfathwjjmdia")
    public suspend fun defaultBackendHttpSettings(`value`: Output<SubResourceArgs>) {
        this.defaultBackendHttpSettings = value
    }

    /**
     * @param value Default Load Distribution Policy resource of URL path map.
     */
    @JvmName("brmhhncwpakdygrn")
    public suspend fun defaultLoadDistributionPolicy(`value`: Output<SubResourceArgs>) {
        this.defaultLoadDistributionPolicy = value
    }

    /**
     * @param value Default redirect configuration resource of URL path map.
     */
    @JvmName("mixnxssnteeysdxf")
    public suspend fun defaultRedirectConfiguration(`value`: Output<SubResourceArgs>) {
        this.defaultRedirectConfiguration = value
    }

    /**
     * @param value Default Rewrite rule set resource of URL path map.
     */
    @JvmName("dfhitplnjdqulrbi")
    public suspend fun defaultRewriteRuleSet(`value`: Output<SubResourceArgs>) {
        this.defaultRewriteRuleSet = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yhhmfwqyojowpmyo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the URL path map that is unique within an Application Gateway.
     */
    @JvmName("vntmmtsbhyhukoue")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Path rule of URL path map resource.
     */
    @JvmName("vqlkscekvrivxxqm")
    public suspend fun pathRules(`value`: Output<List<ApplicationGatewayPathRuleArgs>>) {
        this.pathRules = value
    }

    @JvmName("ygixumuwobjrqcmj")
    public suspend fun pathRules(vararg values: Output<ApplicationGatewayPathRuleArgs>) {
        this.pathRules = Output.all(values.asList())
    }

    /**
     * @param values Path rule of URL path map resource.
     */
    @JvmName("gysbsogbsgbvweif")
    public suspend fun pathRules(values: List<Output<ApplicationGatewayPathRuleArgs>>) {
        this.pathRules = Output.all(values)
    }

    /**
     * @param value Default backend address pool resource of URL path map.
     */
    @JvmName("noiddxihaspbfxem")
    public suspend fun defaultBackendAddressPool(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultBackendAddressPool = mapped
    }

    /**
     * @param argument Default backend address pool resource of URL path map.
     */
    @JvmName("iuvxmrnphhuvhpxk")
    public suspend
    fun defaultBackendAddressPool(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultBackendAddressPool = mapped
    }

    /**
     * @param value Default backend http settings resource of URL path map.
     */
    @JvmName("llbfpgymolssomrq")
    public suspend fun defaultBackendHttpSettings(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultBackendHttpSettings = mapped
    }

    /**
     * @param argument Default backend http settings resource of URL path map.
     */
    @JvmName("nbrardvlcbwmonpt")
    public suspend
    fun defaultBackendHttpSettings(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultBackendHttpSettings = mapped
    }

    /**
     * @param value Default Load Distribution Policy resource of URL path map.
     */
    @JvmName("dochkwtysoytmhas")
    public suspend fun defaultLoadDistributionPolicy(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultLoadDistributionPolicy = mapped
    }

    /**
     * @param argument Default Load Distribution Policy resource of URL path map.
     */
    @JvmName("cvtndikcpnqahsag")
    public suspend
    fun defaultLoadDistributionPolicy(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultLoadDistributionPolicy = mapped
    }

    /**
     * @param value Default redirect configuration resource of URL path map.
     */
    @JvmName("mgybjwtfyjyfnard")
    public suspend fun defaultRedirectConfiguration(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRedirectConfiguration = mapped
    }

    /**
     * @param argument Default redirect configuration resource of URL path map.
     */
    @JvmName("xqwiynyjorawdwyn")
    public suspend
    fun defaultRedirectConfiguration(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultRedirectConfiguration = mapped
    }

    /**
     * @param value Default Rewrite rule set resource of URL path map.
     */
    @JvmName("qplhjbcnpowocpur")
    public suspend fun defaultRewriteRuleSet(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultRewriteRuleSet = mapped
    }

    /**
     * @param argument Default Rewrite rule set resource of URL path map.
     */
    @JvmName("caumrhsqgbxhhgat")
    public suspend fun defaultRewriteRuleSet(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultRewriteRuleSet = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("rctrvsjeotefqdyx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the URL path map that is unique within an Application Gateway.
     */
    @JvmName("abitnvgiddaxeqhp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Path rule of URL path map resource.
     */
    @JvmName("ximxssujssynyytd")
    public suspend fun pathRules(`value`: List<ApplicationGatewayPathRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pathRules = mapped
    }

    /**
     * @param argument Path rule of URL path map resource.
     */
    @JvmName("ymlvmuyhiupqlabb")
    public suspend
    fun pathRules(argument: List<suspend ApplicationGatewayPathRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayPathRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pathRules = mapped
    }

    /**
     * @param argument Path rule of URL path map resource.
     */
    @JvmName("kendynciuhbsdkbb")
    public suspend fun pathRules(
        vararg
        argument: suspend ApplicationGatewayPathRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationGatewayPathRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.pathRules = mapped
    }

    /**
     * @param argument Path rule of URL path map resource.
     */
    @JvmName("pyilqxfgsfjrcmeb")
    public suspend fun pathRules(argument: suspend ApplicationGatewayPathRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGatewayPathRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.pathRules = mapped
    }

    /**
     * @param values Path rule of URL path map resource.
     */
    @JvmName("xitatqnujtxtgqit")
    public suspend fun pathRules(vararg values: ApplicationGatewayPathRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pathRules = mapped
    }

    internal fun build(): ApplicationGatewayUrlPathMapArgs = ApplicationGatewayUrlPathMapArgs(
        defaultBackendAddressPool = defaultBackendAddressPool,
        defaultBackendHttpSettings = defaultBackendHttpSettings,
        defaultLoadDistributionPolicy = defaultLoadDistributionPolicy,
        defaultRedirectConfiguration = defaultRedirectConfiguration,
        defaultRewriteRuleSet = defaultRewriteRuleSet,
        id = id,
        name = name,
        pathRules = pathRules,
    )
}
