@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of an application rule.
 * @property description Description of the rule.
 * @property fqdnTags List of FQDN Tags for this rule.
 * @property name Name of the application rule.
 * @property protocols Array of ApplicationRuleProtocols.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 * @property targetFqdns List of FQDNs for this rule.
 */
public data class AzureFirewallApplicationRuleArgs(
    public val description: Output<String>? = null,
    public val fqdnTags: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val protocols: Output<List<AzureFirewallApplicationRuleProtocolArgs>>? = null,
    public val sourceAddresses: Output<List<String>>? = null,
    public val sourceIpGroups: Output<List<String>>? = null,
    public val targetFqdns: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .fqdnTags(fqdnTags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .protocols(
                protocols?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceAddresses(sourceAddresses?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceIpGroups(sourceIpGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetFqdns(targetFqdns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AzureFirewallApplicationRuleArgs].
 */
@PulumiTagMarker
public class AzureFirewallApplicationRuleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var fqdnTags: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var protocols: Output<List<AzureFirewallApplicationRuleProtocolArgs>>? = null

    private var sourceAddresses: Output<List<String>>? = null

    private var sourceIpGroups: Output<List<String>>? = null

    private var targetFqdns: Output<List<String>>? = null

    /**
     * @param value Description of the rule.
     */
    @JvmName("adyvpsisqorrxwya")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value List of FQDN Tags for this rule.
     */
    @JvmName("bkcllphimsqgawqu")
    public suspend fun fqdnTags(`value`: Output<List<String>>) {
        this.fqdnTags = value
    }

    @JvmName("jwmogldqbyotglof")
    public suspend fun fqdnTags(vararg values: Output<String>) {
        this.fqdnTags = Output.all(values.asList())
    }

    /**
     * @param values List of FQDN Tags for this rule.
     */
    @JvmName("ulrwinkqgqdxodib")
    public suspend fun fqdnTags(values: List<Output<String>>) {
        this.fqdnTags = Output.all(values)
    }

    /**
     * @param value Name of the application rule.
     */
    @JvmName("vwravxcflprjmwqs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Array of ApplicationRuleProtocols.
     */
    @JvmName("gdjkluccboaidoyu")
    public suspend fun protocols(`value`: Output<List<AzureFirewallApplicationRuleProtocolArgs>>) {
        this.protocols = value
    }

    @JvmName("hclibocbpbvmljel")
    public suspend fun protocols(vararg values: Output<AzureFirewallApplicationRuleProtocolArgs>) {
        this.protocols = Output.all(values.asList())
    }

    /**
     * @param values Array of ApplicationRuleProtocols.
     */
    @JvmName("kjdktnklphbnkgog")
    public suspend fun protocols(values: List<Output<AzureFirewallApplicationRuleProtocolArgs>>) {
        this.protocols = Output.all(values)
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("ivftdqqkrnlhlsut")
    public suspend fun sourceAddresses(`value`: Output<List<String>>) {
        this.sourceAddresses = value
    }

    @JvmName("hpkwsfcptgcskcto")
    public suspend fun sourceAddresses(vararg values: Output<String>) {
        this.sourceAddresses = Output.all(values.asList())
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("fvlcadcoamdhhhhi")
    public suspend fun sourceAddresses(values: List<Output<String>>) {
        this.sourceAddresses = Output.all(values)
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("bqxycprfkeghfolq")
    public suspend fun sourceIpGroups(`value`: Output<List<String>>) {
        this.sourceIpGroups = value
    }

    @JvmName("xqxbpuewffyqakdt")
    public suspend fun sourceIpGroups(vararg values: Output<String>) {
        this.sourceIpGroups = Output.all(values.asList())
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("dgaedfbplggdpktq")
    public suspend fun sourceIpGroups(values: List<Output<String>>) {
        this.sourceIpGroups = Output.all(values)
    }

    /**
     * @param value List of FQDNs for this rule.
     */
    @JvmName("prsfqnonjppgjkxj")
    public suspend fun targetFqdns(`value`: Output<List<String>>) {
        this.targetFqdns = value
    }

    @JvmName("ertevffheeyrykph")
    public suspend fun targetFqdns(vararg values: Output<String>) {
        this.targetFqdns = Output.all(values.asList())
    }

    /**
     * @param values List of FQDNs for this rule.
     */
    @JvmName("vhnmqaginmkikrdn")
    public suspend fun targetFqdns(values: List<Output<String>>) {
        this.targetFqdns = Output.all(values)
    }

    /**
     * @param value Description of the rule.
     */
    @JvmName("sdsiqtyisxfenbct")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value List of FQDN Tags for this rule.
     */
    @JvmName("qqaayshfmjrbulub")
    public suspend fun fqdnTags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fqdnTags = mapped
    }

    /**
     * @param values List of FQDN Tags for this rule.
     */
    @JvmName("ixylkvwdcwoxrurw")
    public suspend fun fqdnTags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fqdnTags = mapped
    }

    /**
     * @param value Name of the application rule.
     */
    @JvmName("uuleqvmdrxxpuekm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Array of ApplicationRuleProtocols.
     */
    @JvmName("yqcuwsvxsqladhhd")
    public suspend fun protocols(`value`: List<AzureFirewallApplicationRuleProtocolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param argument Array of ApplicationRuleProtocols.
     */
    @JvmName("fbdqxhkhvuxnjmkl")
    public suspend
    fun protocols(argument: List<suspend AzureFirewallApplicationRuleProtocolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFirewallApplicationRuleProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param argument Array of ApplicationRuleProtocols.
     */
    @JvmName("rvunuqlwmblrymem")
    public suspend fun protocols(
        vararg
        argument: suspend AzureFirewallApplicationRuleProtocolArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureFirewallApplicationRuleProtocolArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param argument Array of ApplicationRuleProtocols.
     */
    @JvmName("agqmxhwabflqayao")
    public suspend
    fun protocols(argument: suspend AzureFirewallApplicationRuleProtocolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureFirewallApplicationRuleProtocolArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.protocols = mapped
    }

    /**
     * @param values Array of ApplicationRuleProtocols.
     */
    @JvmName("rdooipifkeqvcpqy")
    public suspend fun protocols(vararg values: AzureFirewallApplicationRuleProtocolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocols = mapped
    }

    /**
     * @param value List of source IP addresses for this rule.
     */
    @JvmName("bsbhemshrhhbjyoo")
    public suspend fun sourceAddresses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param values List of source IP addresses for this rule.
     */
    @JvmName("knckmglktleqaluh")
    public suspend fun sourceAddresses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAddresses = mapped
    }

    /**
     * @param value List of source IpGroups for this rule.
     */
    @JvmName("uptwfbpjhdmconti")
    public suspend fun sourceIpGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param values List of source IpGroups for this rule.
     */
    @JvmName("wkbscbnkkahynrqn")
    public suspend fun sourceIpGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIpGroups = mapped
    }

    /**
     * @param value List of FQDNs for this rule.
     */
    @JvmName("pktylsttkklloxqh")
    public suspend fun targetFqdns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetFqdns = mapped
    }

    /**
     * @param values List of FQDNs for this rule.
     */
    @JvmName("uppdfxurnyqhlonp")
    public suspend fun targetFqdns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetFqdns = mapped
    }

    internal fun build(): AzureFirewallApplicationRuleArgs = AzureFirewallApplicationRuleArgs(
        description = description,
        fqdnTags = fqdnTags,
        name = name,
        protocols = protocols,
        sourceAddresses = sourceAddresses,
        sourceIpGroups = sourceIpGroups,
        targetFqdns = targetFqdns,
    )
}
