@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleCollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Application rule collection resource.
 * @property action The action type of a rule collection.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
 * @property priority Priority of the application rule collection resource.
 * @property rules Collection of rules used by a application rule collection.
 */
public data class AzureFirewallApplicationRuleCollectionArgs(
    public val action: Output<AzureFirewallRCActionArgs>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val rules: Output<List<AzureFirewallApplicationRuleArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleCollectionArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleCollectionArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallApplicationRuleCollectionArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureFirewallApplicationRuleCollectionArgs].
 */
@PulumiTagMarker
public class AzureFirewallApplicationRuleCollectionArgsBuilder internal constructor() {
    private var action: Output<AzureFirewallRCActionArgs>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var rules: Output<List<AzureFirewallApplicationRuleArgs>>? = null

    /**
     * @param value The action type of a rule collection.
     */
    @JvmName("lsdxyjaaqwiqmlfp")
    public suspend fun action(`value`: Output<AzureFirewallRCActionArgs>) {
        this.action = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cnkvlauxsjfhqbxc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
     */
    @JvmName("uoyjjmhyyaviqbcl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the application rule collection resource.
     */
    @JvmName("dgordidkpimdvypy")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Collection of rules used by a application rule collection.
     */
    @JvmName("qitksfcamqoujpqv")
    public suspend fun rules(`value`: Output<List<AzureFirewallApplicationRuleArgs>>) {
        this.rules = value
    }

    @JvmName("vhmboqqovtqotudn")
    public suspend fun rules(vararg values: Output<AzureFirewallApplicationRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Collection of rules used by a application rule collection.
     */
    @JvmName("rlytxpitlqkcwlls")
    public suspend fun rules(values: List<Output<AzureFirewallApplicationRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The action type of a rule collection.
     */
    @JvmName("cfwdqvragdxxxdnp")
    public suspend fun action(`value`: AzureFirewallRCActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action type of a rule collection.
     */
    @JvmName("nrdqlhatkgpdfmng")
    public suspend fun action(argument: suspend AzureFirewallRCActionArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFirewallRCActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wxtfvtgrhuhucvgu")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
     */
    @JvmName("muaetjkvxxorubpy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the application rule collection resource.
     */
    @JvmName("dgtelguakimbugpi")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Collection of rules used by a application rule collection.
     */
    @JvmName("rbdlymlkfhbswlgf")
    public suspend fun rules(`value`: List<AzureFirewallApplicationRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Collection of rules used by a application rule collection.
     */
    @JvmName("mnicbtnpbtiqshnv")
    public suspend
    fun rules(argument: List<suspend AzureFirewallApplicationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFirewallApplicationRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Collection of rules used by a application rule collection.
     */
    @JvmName("bfixgpxcwqxocahq")
    public suspend fun rules(
        vararg
        argument: suspend AzureFirewallApplicationRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            AzureFirewallApplicationRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Collection of rules used by a application rule collection.
     */
    @JvmName("rlypppyqihljyduv")
    public suspend fun rules(argument: suspend AzureFirewallApplicationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AzureFirewallApplicationRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Collection of rules used by a application rule collection.
     */
    @JvmName("kawkribulfctwqkk")
    public suspend fun rules(vararg values: AzureFirewallApplicationRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): AzureFirewallApplicationRuleCollectionArgs =
        AzureFirewallApplicationRuleCollectionArgs(
            action = action,
            id = id,
            name = name,
            priority = priority,
            rules = rules,
        )
}
