@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.BackendArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.BackendEnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Backend address of a frontDoor load balancer.
 * @property address Location of the backend (IP address or FQDN)
 * @property backendHostHeader The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
 * @property enabledState Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
 * @property httpPort The HTTP TCP port number. Must be between 1 and 65535.
 * @property httpsPort The HTTPS TCP port number. Must be between 1 and 65535.
 * @property priority Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
 * @property privateLinkAlias The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
 * @property privateLinkApprovalMessage A custom message to be included in the approval request to connect to the Private Link
 * @property privateLinkLocation The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
 * @property privateLinkResourceId The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
 * @property weight Weight of this endpoint for load balancing purposes.
 */
public data class BackendArgs(
    public val address: Output<String>? = null,
    public val backendHostHeader: Output<String>? = null,
    public val enabledState: Output<Either<String, BackendEnabledState>>? = null,
    public val httpPort: Output<Int>? = null,
    public val httpsPort: Output<Int>? = null,
    public val priority: Output<Int>? = null,
    public val privateLinkAlias: Output<String>? = null,
    public val privateLinkApprovalMessage: Output<String>? = null,
    public val privateLinkLocation: Output<String>? = null,
    public val privateLinkResourceId: Output<String>? = null,
    public val weight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.BackendArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.BackendArgs =
        com.pulumi.azurenative.network.inputs.BackendArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .backendHostHeader(backendHostHeader?.applyValue({ args0 -> args0 }))
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .httpPort(httpPort?.applyValue({ args0 -> args0 }))
            .httpsPort(httpsPort?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .privateLinkAlias(privateLinkAlias?.applyValue({ args0 -> args0 }))
            .privateLinkApprovalMessage(privateLinkApprovalMessage?.applyValue({ args0 -> args0 }))
            .privateLinkLocation(privateLinkLocation?.applyValue({ args0 -> args0 }))
            .privateLinkResourceId(privateLinkResourceId?.applyValue({ args0 -> args0 }))
            .weight(weight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackendArgs].
 */
@PulumiTagMarker
public class BackendArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var backendHostHeader: Output<String>? = null

    private var enabledState: Output<Either<String, BackendEnabledState>>? = null

    private var httpPort: Output<Int>? = null

    private var httpsPort: Output<Int>? = null

    private var priority: Output<Int>? = null

    private var privateLinkAlias: Output<String>? = null

    private var privateLinkApprovalMessage: Output<String>? = null

    private var privateLinkLocation: Output<String>? = null

    private var privateLinkResourceId: Output<String>? = null

    private var weight: Output<Int>? = null

    /**
     * @param value Location of the backend (IP address or FQDN)
     */
    @JvmName("hogjcemvfksdswmj")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
     */
    @JvmName("dfrrknmhrhkdafhb")
    public suspend fun backendHostHeader(`value`: Output<String>) {
        this.backendHostHeader = value
    }

    /**
     * @param value Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("imcbvxgnirgywypl")
    public suspend fun enabledState(`value`: Output<Either<String, BackendEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value The HTTP TCP port number. Must be between 1 and 65535.
     */
    @JvmName("wfwvqhcdeaewawqq")
    public suspend fun httpPort(`value`: Output<Int>) {
        this.httpPort = value
    }

    /**
     * @param value The HTTPS TCP port number. Must be between 1 and 65535.
     */
    @JvmName("gdatgrkamqhbicwa")
    public suspend fun httpsPort(`value`: Output<Int>) {
        this.httpsPort = value
    }

    /**
     * @param value Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
     */
    @JvmName("jrwjwocssgvkuiqx")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
     */
    @JvmName("ciwfhcvhpwdgfsuy")
    public suspend fun privateLinkAlias(`value`: Output<String>) {
        this.privateLinkAlias = value
    }

    /**
     * @param value A custom message to be included in the approval request to connect to the Private Link
     */
    @JvmName("hstsnbqwjlnjyjwi")
    public suspend fun privateLinkApprovalMessage(`value`: Output<String>) {
        this.privateLinkApprovalMessage = value
    }

    /**
     * @param value The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
     */
    @JvmName("nnfkswoneyxlhtvt")
    public suspend fun privateLinkLocation(`value`: Output<String>) {
        this.privateLinkLocation = value
    }

    /**
     * @param value The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
     */
    @JvmName("skbsvjobunthexho")
    public suspend fun privateLinkResourceId(`value`: Output<String>) {
        this.privateLinkResourceId = value
    }

    /**
     * @param value Weight of this endpoint for load balancing purposes.
     */
    @JvmName("tvwtascltepeftyf")
    public suspend fun weight(`value`: Output<Int>) {
        this.weight = value
    }

    /**
     * @param value Location of the backend (IP address or FQDN)
     */
    @JvmName("bjkhkjchnaimiois")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The value to use as the host header sent to the backend. If blank or unspecified, this defaults to the incoming host.
     */
    @JvmName("naelyvxiptiusdno")
    public suspend fun backendHostHeader(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backendHostHeader = mapped
    }

    /**
     * @param value Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("xexbyachpjronymm")
    public suspend fun enabledState(`value`: Either<String, BackendEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("rlrucctbnyhtvmap")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackendEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Whether to enable use of this backend. Permitted values are 'Enabled' or 'Disabled'
     */
    @JvmName("jorgkmqwyxphqgxr")
    public fun enabledState(`value`: BackendEnabledState) {
        val toBeMapped = Either.ofRight<String, BackendEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value The HTTP TCP port number. Must be between 1 and 65535.
     */
    @JvmName("svjymnhkapecrrxj")
    public suspend fun httpPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPort = mapped
    }

    /**
     * @param value The HTTPS TCP port number. Must be between 1 and 65535.
     */
    @JvmName("aotsqxhijmjstvop")
    public suspend fun httpsPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsPort = mapped
    }

    /**
     * @param value Priority to use for load balancing. Higher priorities will not be used for load balancing if any lower priority backend is healthy.
     */
    @JvmName("lnwjpjvxipbdhlcj")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The Alias of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
     */
    @JvmName("yeyawlsklegxophy")
    public suspend fun privateLinkAlias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkAlias = mapped
    }

    /**
     * @param value A custom message to be included in the approval request to connect to the Private Link
     */
    @JvmName("xkanhaigklxaeeei")
    public suspend fun privateLinkApprovalMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkApprovalMessage = mapped
    }

    /**
     * @param value The location of the Private Link resource. Required only if 'privateLinkResourceId' is populated
     */
    @JvmName("raahhypwntvenvjm")
    public suspend fun privateLinkLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkLocation = mapped
    }

    /**
     * @param value The Resource Id of the Private Link resource. Populating this optional field indicates that this backend is 'Private'
     */
    @JvmName("dvaaxuwkshfluopj")
    public suspend fun privateLinkResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkResourceId = mapped
    }

    /**
     * @param value Weight of this endpoint for load balancing purposes.
     */
    @JvmName("twwlmlwbbujdtfsw")
    public suspend fun weight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weight = mapped
    }

    internal fun build(): BackendArgs = BackendArgs(
        address = address,
        backendHostHeader = backendHostHeader,
        enabledState = enabledState,
        httpPort = httpPort,
        httpsPort = httpsPort,
        priority = priority,
        privateLinkAlias = privateLinkAlias,
        privateLinkApprovalMessage = privateLinkApprovalMessage,
        privateLinkLocation = privateLinkLocation,
        privateLinkResourceId = privateLinkResourceId,
        weight = weight,
    )
}
