@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.BgpSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * BGP settings details.
 * @property asn The BGP speaker's ASN.
 * @property bgpPeeringAddress The BGP peering address and BGP identifier of this BGP speaker.
 * @property bgpPeeringAddresses BGP peering address with IP configuration ID for virtual network gateway.
 * @property peerWeight The weight added to routes learned from this BGP speaker.
 */
public data class BgpSettingsArgs(
    public val asn: Output<Double>? = null,
    public val bgpPeeringAddress: Output<String>? = null,
    public val bgpPeeringAddresses: Output<List<IPConfigurationBgpPeeringAddressArgs>>? = null,
    public val peerWeight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.BgpSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.BgpSettingsArgs =
        com.pulumi.azurenative.network.inputs.BgpSettingsArgs.builder()
            .asn(asn?.applyValue({ args0 -> args0 }))
            .bgpPeeringAddress(bgpPeeringAddress?.applyValue({ args0 -> args0 }))
            .bgpPeeringAddresses(
                bgpPeeringAddresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .peerWeight(peerWeight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpSettingsArgs].
 */
@PulumiTagMarker
public class BgpSettingsArgsBuilder internal constructor() {
    private var asn: Output<Double>? = null

    private var bgpPeeringAddress: Output<String>? = null

    private var bgpPeeringAddresses: Output<List<IPConfigurationBgpPeeringAddressArgs>>? = null

    private var peerWeight: Output<Int>? = null

    /**
     * @param value The BGP speaker's ASN.
     */
    @JvmName("syrfxlsisyojcdeh")
    public suspend fun asn(`value`: Output<Double>) {
        this.asn = value
    }

    /**
     * @param value The BGP peering address and BGP identifier of this BGP speaker.
     */
    @JvmName("qdbmspqtbiolskea")
    public suspend fun bgpPeeringAddress(`value`: Output<String>) {
        this.bgpPeeringAddress = value
    }

    /**
     * @param value BGP peering address with IP configuration ID for virtual network gateway.
     */
    @JvmName("rddxnqrygiyoyutc")
    public suspend
    fun bgpPeeringAddresses(`value`: Output<List<IPConfigurationBgpPeeringAddressArgs>>) {
        this.bgpPeeringAddresses = value
    }

    @JvmName("wmylppdppbsxarab")
    public suspend fun bgpPeeringAddresses(
        vararg
        values: Output<IPConfigurationBgpPeeringAddressArgs>,
    ) {
        this.bgpPeeringAddresses = Output.all(values.asList())
    }

    /**
     * @param values BGP peering address with IP configuration ID for virtual network gateway.
     */
    @JvmName("vabfuocmsfstqrwo")
    public suspend
    fun bgpPeeringAddresses(values: List<Output<IPConfigurationBgpPeeringAddressArgs>>) {
        this.bgpPeeringAddresses = Output.all(values)
    }

    /**
     * @param value The weight added to routes learned from this BGP speaker.
     */
    @JvmName("lonlvfrtfmdqmdrw")
    public suspend fun peerWeight(`value`: Output<Int>) {
        this.peerWeight = value
    }

    /**
     * @param value The BGP speaker's ASN.
     */
    @JvmName("mcwbveufqsivljft")
    public suspend fun asn(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asn = mapped
    }

    /**
     * @param value The BGP peering address and BGP identifier of this BGP speaker.
     */
    @JvmName("ggyfkxvhxolrjgpf")
    public suspend fun bgpPeeringAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpPeeringAddress = mapped
    }

    /**
     * @param value BGP peering address with IP configuration ID for virtual network gateway.
     */
    @JvmName("eaenqrremdcjiuco")
    public suspend fun bgpPeeringAddresses(`value`: List<IPConfigurationBgpPeeringAddressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpPeeringAddresses = mapped
    }

    /**
     * @param argument BGP peering address with IP configuration ID for virtual network gateway.
     */
    @JvmName("ctpalglqxqvrthbi")
    public suspend
    fun bgpPeeringAddresses(argument: List<suspend IPConfigurationBgpPeeringAddressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IPConfigurationBgpPeeringAddressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.bgpPeeringAddresses = mapped
    }

    /**
     * @param argument BGP peering address with IP configuration ID for virtual network gateway.
     */
    @JvmName("vckshbawknvspelm")
    public suspend fun bgpPeeringAddresses(
        vararg
        argument: suspend IPConfigurationBgpPeeringAddressArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IPConfigurationBgpPeeringAddressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.bgpPeeringAddresses = mapped
    }

    /**
     * @param argument BGP peering address with IP configuration ID for virtual network gateway.
     */
    @JvmName("ajrurjmfwreypbhu")
    public suspend
    fun bgpPeeringAddresses(argument: suspend IPConfigurationBgpPeeringAddressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            IPConfigurationBgpPeeringAddressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.bgpPeeringAddresses = mapped
    }

    /**
     * @param values BGP peering address with IP configuration ID for virtual network gateway.
     */
    @JvmName("iqvxjonrsnbkparc")
    public suspend fun bgpPeeringAddresses(vararg values: IPConfigurationBgpPeeringAddressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bgpPeeringAddresses = mapped
    }

    /**
     * @param value The weight added to routes learned from this BGP speaker.
     */
    @JvmName("rgspawhktlepslqr")
    public suspend fun peerWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peerWeight = mapped
    }

    internal fun build(): BgpSettingsArgs = BgpSettingsArgs(
        asn = asn,
        bgpPeeringAddress = bgpPeeringAddress,
        bgpPeeringAddresses = bgpPeeringAddresses,
        peerWeight = peerWeight,
    )
}
