@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the destination of connection monitor.
 * @property address Address of the connection monitor destination (IP or domain name).
 * @property port The destination port used by connection monitor.
 * @property resourceId The ID of the resource used as the destination by connection monitor.
 */
public data class ConnectionMonitorDestinationArgs(
    public val address: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val resourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorDestinationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorDestinationArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorDestinationArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionMonitorDestinationArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorDestinationArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var port: Output<Int>? = null

    private var resourceId: Output<String>? = null

    /**
     * @param value Address of the connection monitor destination (IP or domain name).
     */
    @JvmName("kewyuppxytcebvfk")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The destination port used by connection monitor.
     */
    @JvmName("oytkpbaquttyqpxd")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The ID of the resource used as the destination by connection monitor.
     */
    @JvmName("btivvpehaoioiodq")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value Address of the connection monitor destination (IP or domain name).
     */
    @JvmName("fxevejcgmjljjcim")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The destination port used by connection monitor.
     */
    @JvmName("rplrolbmolrahegr")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The ID of the resource used as the destination by connection monitor.
     */
    @JvmName("ypsqcjdgmoddhhut")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    internal fun build(): ConnectionMonitorDestinationArgs = ConnectionMonitorDestinationArgs(
        address = address,
        port = port,
        resourceId = resourceId,
    )
}
