@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the connection monitor endpoint scope.
 * @property exclude List of items which needs to be excluded from the endpoint scope.
 * @property include List of items which needs to be included to the endpoint scope.
 */
public data class ConnectionMonitorEndpointScopeArgs(
    public val exclude: Output<List<ConnectionMonitorEndpointScopeItemArgs>>? = null,
    public val include: Output<List<ConnectionMonitorEndpointScopeItemArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointScopeArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointScopeArgs.builder()
            .exclude(
                exclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .include(
                include?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionMonitorEndpointScopeArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorEndpointScopeArgsBuilder internal constructor() {
    private var exclude: Output<List<ConnectionMonitorEndpointScopeItemArgs>>? = null

    private var include: Output<List<ConnectionMonitorEndpointScopeItemArgs>>? = null

    /**
     * @param value List of items which needs to be excluded from the endpoint scope.
     */
    @JvmName("lafwilkymainbmef")
    public suspend fun exclude(`value`: Output<List<ConnectionMonitorEndpointScopeItemArgs>>) {
        this.exclude = value
    }

    @JvmName("rswirwyelujavbna")
    public suspend fun exclude(vararg values: Output<ConnectionMonitorEndpointScopeItemArgs>) {
        this.exclude = Output.all(values.asList())
    }

    /**
     * @param values List of items which needs to be excluded from the endpoint scope.
     */
    @JvmName("puinosfhfnvmvgyu")
    public suspend fun exclude(values: List<Output<ConnectionMonitorEndpointScopeItemArgs>>) {
        this.exclude = Output.all(values)
    }

    /**
     * @param value List of items which needs to be included to the endpoint scope.
     */
    @JvmName("guifhrajtpeluwet")
    public suspend fun include(`value`: Output<List<ConnectionMonitorEndpointScopeItemArgs>>) {
        this.include = value
    }

    @JvmName("dahkjchyaxtuqhob")
    public suspend fun include(vararg values: Output<ConnectionMonitorEndpointScopeItemArgs>) {
        this.include = Output.all(values.asList())
    }

    /**
     * @param values List of items which needs to be included to the endpoint scope.
     */
    @JvmName("ycrlmccrewhupkrn")
    public suspend fun include(values: List<Output<ConnectionMonitorEndpointScopeItemArgs>>) {
        this.include = Output.all(values)
    }

    /**
     * @param value List of items which needs to be excluded from the endpoint scope.
     */
    @JvmName("idbgshpgcrfoqviv")
    public suspend fun exclude(`value`: List<ConnectionMonitorEndpointScopeItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclude = mapped
    }

    /**
     * @param argument List of items which needs to be excluded from the endpoint scope.
     */
    @JvmName("fsfqyehmwvvibkec")
    public suspend
    fun exclude(argument: List<suspend ConnectionMonitorEndpointScopeItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorEndpointScopeItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.exclude = mapped
    }

    /**
     * @param argument List of items which needs to be excluded from the endpoint scope.
     */
    @JvmName("tfajvomgstbxwtyx")
    public suspend fun exclude(
        vararg
        argument: suspend ConnectionMonitorEndpointScopeItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorEndpointScopeItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.exclude = mapped
    }

    /**
     * @param argument List of items which needs to be excluded from the endpoint scope.
     */
    @JvmName("aqqgwldircxpynhh")
    public suspend
    fun exclude(argument: suspend ConnectionMonitorEndpointScopeItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectionMonitorEndpointScopeItemArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.exclude = mapped
    }

    /**
     * @param values List of items which needs to be excluded from the endpoint scope.
     */
    @JvmName("bjyfowjqqvbcmsak")
    public suspend fun exclude(vararg values: ConnectionMonitorEndpointScopeItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclude = mapped
    }

    /**
     * @param value List of items which needs to be included to the endpoint scope.
     */
    @JvmName("mdejbxarkqbjalhb")
    public suspend fun include(`value`: List<ConnectionMonitorEndpointScopeItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.include = mapped
    }

    /**
     * @param argument List of items which needs to be included to the endpoint scope.
     */
    @JvmName("ueoryktpjndntldb")
    public suspend
    fun include(argument: List<suspend ConnectionMonitorEndpointScopeItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorEndpointScopeItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.include = mapped
    }

    /**
     * @param argument List of items which needs to be included to the endpoint scope.
     */
    @JvmName("yxwqhdompovuowmy")
    public suspend fun include(
        vararg
        argument: suspend ConnectionMonitorEndpointScopeItemArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConnectionMonitorEndpointScopeItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.include = mapped
    }

    /**
     * @param argument List of items which needs to be included to the endpoint scope.
     */
    @JvmName("shudqupyhjcodqoo")
    public suspend
    fun include(argument: suspend ConnectionMonitorEndpointScopeItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ConnectionMonitorEndpointScopeItemArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.include = mapped
    }

    /**
     * @param values List of items which needs to be included to the endpoint scope.
     */
    @JvmName("enqsnkgdfhcpsvfv")
    public suspend fun include(vararg values: ConnectionMonitorEndpointScopeItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.include = mapped
    }

    internal fun build(): ConnectionMonitorEndpointScopeArgs = ConnectionMonitorEndpointScopeArgs(
        exclude = exclude,
        include = include,
    )
}
