@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointScopeItemArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the connection monitor endpoint scope item.
 * @property address The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or IPv4/IPv6 IP address.
 */
public data class ConnectionMonitorEndpointScopeItemArgs(
    public val address: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointScopeItemArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointScopeItemArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointScopeItemArgs.builder()
            .address(address?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionMonitorEndpointScopeItemArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorEndpointScopeItemArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    /**
     * @param value The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or IPv4/IPv6 IP address.
     */
    @JvmName("ssalgsywctkbgnqo")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The address of the endpoint item. Supported types are IPv4/IPv6 subnet mask or IPv4/IPv6 IP address.
     */
    @JvmName("kpdtqtboyntcqahj")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    internal fun build(): ConnectionMonitorEndpointScopeItemArgs =
        ConnectionMonitorEndpointScopeItemArgs(
            address = address,
        )
}
