@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorHttpConfigurationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.HTTPConfigurationMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the HTTP configuration.
 * @property method The HTTP method to use.
 * @property path The path component of the URI. For instance, "/dir1/dir2".
 * @property port The port to connect to.
 * @property preferHTTPS Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
 * @property requestHeaders The HTTP headers to transmit with the request.
 * @property validStatusCodeRanges HTTP status codes to consider successful. For instance, "2xx,301-304,418".
 */
public data class ConnectionMonitorHttpConfigurationArgs(
    public val method: Output<Either<String, HTTPConfigurationMethod>>? = null,
    public val path: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val preferHTTPS: Output<Boolean>? = null,
    public val requestHeaders: Output<List<HTTPHeaderArgs>>? = null,
    public val validStatusCodeRanges: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorHttpConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ConnectionMonitorHttpConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorHttpConfigurationArgs.builder()
            .method(
                method?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .path(path?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .preferHTTPS(preferHTTPS?.applyValue({ args0 -> args0 }))
            .requestHeaders(
                requestHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .validStatusCodeRanges(
                validStatusCodeRanges?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionMonitorHttpConfigurationArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorHttpConfigurationArgsBuilder internal constructor() {
    private var method: Output<Either<String, HTTPConfigurationMethod>>? = null

    private var path: Output<String>? = null

    private var port: Output<Int>? = null

    private var preferHTTPS: Output<Boolean>? = null

    private var requestHeaders: Output<List<HTTPHeaderArgs>>? = null

    private var validStatusCodeRanges: Output<List<String>>? = null

    /**
     * @param value The HTTP method to use.
     */
    @JvmName("xsaovfaccfjysyqu")
    public suspend fun method(`value`: Output<Either<String, HTTPConfigurationMethod>>) {
        this.method = value
    }

    /**
     * @param value The path component of the URI. For instance, "/dir1/dir2".
     */
    @JvmName("iqourbdixfhqvnwa")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value The port to connect to.
     */
    @JvmName("qtscjxfckkiypcyb")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
     */
    @JvmName("ikrgaqicmouarnjn")
    public suspend fun preferHTTPS(`value`: Output<Boolean>) {
        this.preferHTTPS = value
    }

    /**
     * @param value The HTTP headers to transmit with the request.
     */
    @JvmName("simxyyhfrbhlniuq")
    public suspend fun requestHeaders(`value`: Output<List<HTTPHeaderArgs>>) {
        this.requestHeaders = value
    }

    @JvmName("vqyfmicwsvocpfxh")
    public suspend fun requestHeaders(vararg values: Output<HTTPHeaderArgs>) {
        this.requestHeaders = Output.all(values.asList())
    }

    /**
     * @param values The HTTP headers to transmit with the request.
     */
    @JvmName("lirkhythplkjyqwi")
    public suspend fun requestHeaders(values: List<Output<HTTPHeaderArgs>>) {
        this.requestHeaders = Output.all(values)
    }

    /**
     * @param value HTTP status codes to consider successful. For instance, "2xx,301-304,418".
     */
    @JvmName("ydndndreqbihknot")
    public suspend fun validStatusCodeRanges(`value`: Output<List<String>>) {
        this.validStatusCodeRanges = value
    }

    @JvmName("bmvurjoqihabujjw")
    public suspend fun validStatusCodeRanges(vararg values: Output<String>) {
        this.validStatusCodeRanges = Output.all(values.asList())
    }

    /**
     * @param values HTTP status codes to consider successful. For instance, "2xx,301-304,418".
     */
    @JvmName("kenmndmkmutshwml")
    public suspend fun validStatusCodeRanges(values: List<Output<String>>) {
        this.validStatusCodeRanges = Output.all(values)
    }

    /**
     * @param value The HTTP method to use.
     */
    @JvmName("vpbtowljotwhfvgd")
    public suspend fun method(`value`: Either<String, HTTPConfigurationMethod>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The HTTP method to use.
     */
    @JvmName("bamkcgxxgqnqkktr")
    public fun method(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HTTPConfigurationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The HTTP method to use.
     */
    @JvmName("hacwtjevkpbiqkyf")
    public fun method(`value`: HTTPConfigurationMethod) {
        val toBeMapped = Either.ofRight<String, HTTPConfigurationMethod>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The path component of the URI. For instance, "/dir1/dir2".
     */
    @JvmName("cgqfiqvpgldjfduh")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value The port to connect to.
     */
    @JvmName("bxjaedvvwtyqxvyk")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Value indicating whether HTTPS is preferred over HTTP in cases where the choice is not explicit.
     */
    @JvmName("fetygawcupipphnv")
    public suspend fun preferHTTPS(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferHTTPS = mapped
    }

    /**
     * @param value The HTTP headers to transmit with the request.
     */
    @JvmName("kygsnngibtkqsmip")
    public suspend fun requestHeaders(`value`: List<HTTPHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestHeaders = mapped
    }

    /**
     * @param argument The HTTP headers to transmit with the request.
     */
    @JvmName("pmxbhlwqfwlquxbi")
    public suspend fun requestHeaders(argument: List<suspend HTTPHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { HTTPHeaderArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.requestHeaders = mapped
    }

    /**
     * @param argument The HTTP headers to transmit with the request.
     */
    @JvmName("nfcnamqlfqbqonyx")
    public suspend fun requestHeaders(vararg argument: suspend HTTPHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { HTTPHeaderArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.requestHeaders = mapped
    }

    /**
     * @param argument The HTTP headers to transmit with the request.
     */
    @JvmName("wsnpwyaqxqrhxvnn")
    public suspend fun requestHeaders(argument: suspend HTTPHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HTTPHeaderArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.requestHeaders = mapped
    }

    /**
     * @param values The HTTP headers to transmit with the request.
     */
    @JvmName("wtubldmijakvobjc")
    public suspend fun requestHeaders(vararg values: HTTPHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestHeaders = mapped
    }

    /**
     * @param value HTTP status codes to consider successful. For instance, "2xx,301-304,418".
     */
    @JvmName("lhwxjofmyyvanlbu")
    public suspend fun validStatusCodeRanges(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validStatusCodeRanges = mapped
    }

    /**
     * @param values HTTP status codes to consider successful. For instance, "2xx,301-304,418".
     */
    @JvmName("cvmjrjssnoqohjsn")
    public suspend fun validStatusCodeRanges(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validStatusCodeRanges = mapped
    }

    internal fun build(): ConnectionMonitorHttpConfigurationArgs =
        ConnectionMonitorHttpConfigurationArgs(
            method = method,
            path = path,
            port = port,
            preferHTTPS = preferHTTPS,
            requestHeaders = requestHeaders,
            validStatusCodeRanges = validStatusCodeRanges,
        )
}
