@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectivityGroupItemArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.GroupConnectivity
import com.pulumi.azurenative.network.kotlin.enums.IsGlobal
import com.pulumi.azurenative.network.kotlin.enums.UseHubGateway
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connectivity group item.
 * @property groupConnectivity Group connectivity type.
 * @property isGlobal Flag if global is supported.
 * @property networkGroupId Network group Id.
 * @property useHubGateway Flag if need to use hub gateway.
 */
public data class ConnectivityGroupItemArgs(
    public val groupConnectivity: Output<Either<String, GroupConnectivity>>,
    public val isGlobal: Output<Either<String, IsGlobal>>? = null,
    public val networkGroupId: Output<String>,
    public val useHubGateway: Output<Either<String, UseHubGateway>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectivityGroupItemArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectivityGroupItemArgs =
        com.pulumi.azurenative.network.inputs.ConnectivityGroupItemArgs.builder()
            .groupConnectivity(
                groupConnectivity.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .isGlobal(
                isGlobal?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkGroupId(networkGroupId.applyValue({ args0 -> args0 }))
            .useHubGateway(
                useHubGateway?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectivityGroupItemArgs].
 */
@PulumiTagMarker
public class ConnectivityGroupItemArgsBuilder internal constructor() {
    private var groupConnectivity: Output<Either<String, GroupConnectivity>>? = null

    private var isGlobal: Output<Either<String, IsGlobal>>? = null

    private var networkGroupId: Output<String>? = null

    private var useHubGateway: Output<Either<String, UseHubGateway>>? = null

    /**
     * @param value Group connectivity type.
     */
    @JvmName("wdtookilvmyggkxl")
    public suspend fun groupConnectivity(`value`: Output<Either<String, GroupConnectivity>>) {
        this.groupConnectivity = value
    }

    /**
     * @param value Flag if global is supported.
     */
    @JvmName("jkcnesnbhegefnxw")
    public suspend fun isGlobal(`value`: Output<Either<String, IsGlobal>>) {
        this.isGlobal = value
    }

    /**
     * @param value Network group Id.
     */
    @JvmName("vddhyejibxyksybe")
    public suspend fun networkGroupId(`value`: Output<String>) {
        this.networkGroupId = value
    }

    /**
     * @param value Flag if need to use hub gateway.
     */
    @JvmName("xiwxopapwhdknndt")
    public suspend fun useHubGateway(`value`: Output<Either<String, UseHubGateway>>) {
        this.useHubGateway = value
    }

    /**
     * @param value Group connectivity type.
     */
    @JvmName("glqvwwspvognbqxm")
    public suspend fun groupConnectivity(`value`: Either<String, GroupConnectivity>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupConnectivity = mapped
    }

    /**
     * @param value Group connectivity type.
     */
    @JvmName("jqrlyiataindlkht")
    public fun groupConnectivity(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GroupConnectivity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupConnectivity = mapped
    }

    /**
     * @param value Group connectivity type.
     */
    @JvmName("yxmfipuauxrkqmwq")
    public fun groupConnectivity(`value`: GroupConnectivity) {
        val toBeMapped = Either.ofRight<String, GroupConnectivity>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupConnectivity = mapped
    }

    /**
     * @param value Flag if global is supported.
     */
    @JvmName("popipxualiatqbkd")
    public suspend fun isGlobal(`value`: Either<String, IsGlobal>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isGlobal = mapped
    }

    /**
     * @param value Flag if global is supported.
     */
    @JvmName("pywxainjdxmblmqo")
    public fun isGlobal(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IsGlobal>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isGlobal = mapped
    }

    /**
     * @param value Flag if global is supported.
     */
    @JvmName("hayfvkullygmpmnh")
    public fun isGlobal(`value`: IsGlobal) {
        val toBeMapped = Either.ofRight<String, IsGlobal>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isGlobal = mapped
    }

    /**
     * @param value Network group Id.
     */
    @JvmName("rxsaedhheyxqxkgy")
    public suspend fun networkGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkGroupId = mapped
    }

    /**
     * @param value Flag if need to use hub gateway.
     */
    @JvmName("oohtxtendjjkabuh")
    public suspend fun useHubGateway(`value`: Either<String, UseHubGateway>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useHubGateway = mapped
    }

    /**
     * @param value Flag if need to use hub gateway.
     */
    @JvmName("qopwiwcajyulfmhs")
    public fun useHubGateway(`value`: String) {
        val toBeMapped = Either.ofLeft<String, UseHubGateway>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useHubGateway = mapped
    }

    /**
     * @param value Flag if need to use hub gateway.
     */
    @JvmName("xublqbjpeiwnddwl")
    public fun useHubGateway(`value`: UseHubGateway) {
        val toBeMapped = Either.ofRight<String, UseHubGateway>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.useHubGateway = mapped
    }

    internal fun build(): ConnectivityGroupItemArgs = ConnectivityGroupItemArgs(
        groupConnectivity = groupConnectivity ?: throw PulumiNullFieldException("groupConnectivity"),
        isGlobal = isGlobal,
        networkGroupId = networkGroupId ?: throw PulumiNullFieldException("networkGroupId"),
        useHubGateway = useHubGateway,
    )
}
