@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ContainerNetworkInterfaceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Container network interface configuration child resource.
 * @property containerNetworkInterfaces A list of container network interfaces created from this container network interface configuration.
 * @property id Resource ID.
 * @property ipConfigurations A list of ip configurations of the container network interface configuration.
 * @property name The name of the resource. This name can be used to access the resource.
 */
public data class ContainerNetworkInterfaceConfigurationArgs(
    public val containerNetworkInterfaces: Output<List<SubResourceArgs>>? = null,
    public val id: Output<String>? = null,
    public val ipConfigurations: Output<List<IPConfigurationProfileArgs>>? = null,
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ContainerNetworkInterfaceConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ContainerNetworkInterfaceConfigurationArgs =
        com.pulumi.azurenative.network.inputs.ContainerNetworkInterfaceConfigurationArgs.builder()
            .containerNetworkInterfaces(
                containerNetworkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerNetworkInterfaceConfigurationArgs].
 */
@PulumiTagMarker
public class ContainerNetworkInterfaceConfigurationArgsBuilder internal constructor() {
    private var containerNetworkInterfaces: Output<List<SubResourceArgs>>? = null

    private var id: Output<String>? = null

    private var ipConfigurations: Output<List<IPConfigurationProfileArgs>>? = null

    private var name: Output<String>? = null

    /**
     * @param value A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("oveavmvjfurqcrtk")
    public suspend fun containerNetworkInterfaces(`value`: Output<List<SubResourceArgs>>) {
        this.containerNetworkInterfaces = value
    }

    @JvmName("yqrlyilipfnmrgxm")
    public suspend fun containerNetworkInterfaces(vararg values: Output<SubResourceArgs>) {
        this.containerNetworkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("ceqgupqigkbtidcm")
    public suspend fun containerNetworkInterfaces(values: List<Output<SubResourceArgs>>) {
        this.containerNetworkInterfaces = Output.all(values)
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("tnuhymrmtkxhboye")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value A list of ip configurations of the container network interface configuration.
     */
    @JvmName("pqtpixoawwymbxma")
    public suspend fun ipConfigurations(`value`: Output<List<IPConfigurationProfileArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("byugcxwvrgmdmmex")
    public suspend fun ipConfigurations(vararg values: Output<IPConfigurationProfileArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values A list of ip configurations of the container network interface configuration.
     */
    @JvmName("nndhsmjbtralwxys")
    public suspend fun ipConfigurations(values: List<Output<IPConfigurationProfileArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value The name of the resource. This name can be used to access the resource.
     */
    @JvmName("qgvvdacyheqcqxjs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("wusvnccnxadqhucu")
    public suspend fun containerNetworkInterfaces(`value`: List<SubResourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerNetworkInterfaces = mapped
    }

    /**
     * @param argument A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("lpvmxpqhgubtykpx")
    public suspend
    fun containerNetworkInterfaces(argument: List<suspend SubResourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containerNetworkInterfaces = mapped
    }

    /**
     * @param argument A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("lerxdhnnmbdlebdx")
    public suspend fun containerNetworkInterfaces(
        vararg
        argument: suspend SubResourceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map { SubResourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.containerNetworkInterfaces = mapped
    }

    /**
     * @param argument A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("egmakkovgavgicwq")
    public suspend
    fun containerNetworkInterfaces(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.containerNetworkInterfaces = mapped
    }

    /**
     * @param values A list of container network interfaces created from this container network interface configuration.
     */
    @JvmName("qgutvenjiagelhvj")
    public suspend fun containerNetworkInterfaces(vararg values: SubResourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerNetworkInterfaces = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("xkmydpvigjpktuls")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value A list of ip configurations of the container network interface configuration.
     */
    @JvmName("pvlbqbhocgwvuuug")
    public suspend fun ipConfigurations(`value`: List<IPConfigurationProfileArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of ip configurations of the container network interface configuration.
     */
    @JvmName("jnktqulsdwyceqcp")
    public suspend
    fun ipConfigurations(argument: List<suspend IPConfigurationProfileArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IPConfigurationProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of ip configurations of the container network interface configuration.
     */
    @JvmName("emeysdkhklmkkepa")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend IPConfigurationProfileArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IPConfigurationProfileArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument A list of ip configurations of the container network interface configuration.
     */
    @JvmName("bpoaskwahkoqbjvo")
    public suspend
    fun ipConfigurations(argument: suspend IPConfigurationProfileArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPConfigurationProfileArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values A list of ip configurations of the container network interface configuration.
     */
    @JvmName("dgnqsjvkvmdkxtdb")
    public suspend fun ipConfigurations(vararg values: IPConfigurationProfileArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value The name of the resource. This name can be used to access the resource.
     */
    @JvmName("bgscfhyyfljpjads")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ContainerNetworkInterfaceConfigurationArgs =
        ContainerNetworkInterfaceConfigurationArgs(
            containerNetworkInterfaces = containerNetworkInterfaces,
            id = id,
            ipConfigurations = ipConfigurations,
            name = name,
        )
}
