@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.DnsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * DNS Proxy Settings in Firewall Policy.
 * @property enableProxy Enable DNS Proxy on Firewalls attached to the Firewall Policy.
 * @property requireProxyForNetworkRules FQDNs in Network Rules are supported when set to true.
 * @property servers List of Custom DNS Servers.
 */
public data class DnsSettingsArgs(
    public val enableProxy: Output<Boolean>? = null,
    public val requireProxyForNetworkRules: Output<Boolean>? = null,
    public val servers: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.DnsSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.DnsSettingsArgs =
        com.pulumi.azurenative.network.inputs.DnsSettingsArgs.builder()
            .enableProxy(enableProxy?.applyValue({ args0 -> args0 }))
            .requireProxyForNetworkRules(requireProxyForNetworkRules?.applyValue({ args0 -> args0 }))
            .servers(servers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DnsSettingsArgs].
 */
@PulumiTagMarker
public class DnsSettingsArgsBuilder internal constructor() {
    private var enableProxy: Output<Boolean>? = null

    private var requireProxyForNetworkRules: Output<Boolean>? = null

    private var servers: Output<List<String>>? = null

    /**
     * @param value Enable DNS Proxy on Firewalls attached to the Firewall Policy.
     */
    @JvmName("xhsffayhkvadvrcx")
    public suspend fun enableProxy(`value`: Output<Boolean>) {
        this.enableProxy = value
    }

    /**
     * @param value FQDNs in Network Rules are supported when set to true.
     */
    @JvmName("udocxuveaarolsgf")
    public suspend fun requireProxyForNetworkRules(`value`: Output<Boolean>) {
        this.requireProxyForNetworkRules = value
    }

    /**
     * @param value List of Custom DNS Servers.
     */
    @JvmName("oupcaaiwvsrigqof")
    public suspend fun servers(`value`: Output<List<String>>) {
        this.servers = value
    }

    @JvmName("krysfmnyvyymeaul")
    public suspend fun servers(vararg values: Output<String>) {
        this.servers = Output.all(values.asList())
    }

    /**
     * @param values List of Custom DNS Servers.
     */
    @JvmName("icecoftsepnqfhuk")
    public suspend fun servers(values: List<Output<String>>) {
        this.servers = Output.all(values)
    }

    /**
     * @param value Enable DNS Proxy on Firewalls attached to the Firewall Policy.
     */
    @JvmName("cxcrioedmraoahsx")
    public suspend fun enableProxy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableProxy = mapped
    }

    /**
     * @param value FQDNs in Network Rules are supported when set to true.
     */
    @JvmName("qvlnuqqqtcnibhcb")
    public suspend fun requireProxyForNetworkRules(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireProxyForNetworkRules = mapped
    }

    /**
     * @param value List of Custom DNS Servers.
     */
    @JvmName("xwdyecpnoulpjcln")
    public suspend fun servers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servers = mapped
    }

    /**
     * @param values List of Custom DNS Servers.
     */
    @JvmName("lhltirxcqbkraymw")
    public suspend fun servers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servers = mapped
    }

    internal fun build(): DnsSettingsArgs = DnsSettingsArgs(
        enableProxy = enableProxy,
        requireProxyForNetworkRules = requireProxyForNetworkRules,
        servers = servers,
    )
}
