@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.EndpointServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identifies the service being brought into the virtual network.
 * @property id A unique identifier of the service being referenced by the interface endpoint.
 */
public data class EndpointServiceArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.EndpointServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.EndpointServiceArgs =
        com.pulumi.azurenative.network.inputs.EndpointServiceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointServiceArgs].
 */
@PulumiTagMarker
public class EndpointServiceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value A unique identifier of the service being referenced by the interface endpoint.
     */
    @JvmName("lkjgbueukbqibpcw")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value A unique identifier of the service being referenced by the interface endpoint.
     */
    @JvmName("cyvierciinmtuxju")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): EndpointServiceArgs = EndpointServiceArgs(
        id = id,
    )
}
