@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExclusionManagedRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines a managed rule to use for exclusion.
 * @property ruleId Identifier for the managed rule.
 */
public data class ExclusionManagedRuleArgs(
    public val ruleId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExclusionManagedRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExclusionManagedRuleArgs =
        com.pulumi.azurenative.network.inputs.ExclusionManagedRuleArgs.builder()
            .ruleId(ruleId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExclusionManagedRuleArgs].
 */
@PulumiTagMarker
public class ExclusionManagedRuleArgsBuilder internal constructor() {
    private var ruleId: Output<String>? = null

    /**
     * @param value Identifier for the managed rule.
     */
    @JvmName("xyhivpdvelxbyonw")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value Identifier for the managed rule.
     */
    @JvmName("iopsorycwkscwoxx")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    internal fun build(): ExclusionManagedRuleArgs = ExclusionManagedRuleArgs(
        ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
    )
}
