@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExperimentEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the endpoint properties
 * @property endpoint The endpoint URL
 * @property name The name of the endpoint
 */
public data class ExperimentEndpointArgs(
    public val endpoint: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExperimentEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExperimentEndpointArgs =
        com.pulumi.azurenative.network.inputs.ExperimentEndpointArgs.builder()
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExperimentEndpointArgs].
 */
@PulumiTagMarker
public class ExperimentEndpointArgsBuilder internal constructor() {
    private var endpoint: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The endpoint URL
     */
    @JvmName("vgksmhaqvqsoewbe")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value The name of the endpoint
     */
    @JvmName("ufynsupivuxbpptc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The endpoint URL
     */
    @JvmName("tjotluumijjmdpmi")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value The name of the endpoint
     */
    @JvmName("utdejwyucrwljyks")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ExperimentEndpointArgs = ExperimentEndpointArgs(
        endpoint = endpoint,
        name = name,
    )
}
