@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExplicitProxyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Explicit Proxy Settings in Firewall Policy.
 * @property enableExplicitProxy When set to true, explicit proxy mode is enabled.
 * @property enablePacFile When set to true, pac file port and url needs to be provided.
 * @property httpPort Port number for explicit proxy http protocol, cannot be greater than 64000.
 * @property httpsPort Port number for explicit proxy https protocol, cannot be greater than 64000.
 * @property pacFile SAS URL for PAC file.
 * @property pacFilePort Port number for firewall to serve PAC file.
 */
public data class ExplicitProxyArgs(
    public val enableExplicitProxy: Output<Boolean>? = null,
    public val enablePacFile: Output<Boolean>? = null,
    public val httpPort: Output<Int>? = null,
    public val httpsPort: Output<Int>? = null,
    public val pacFile: Output<String>? = null,
    public val pacFilePort: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExplicitProxyArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExplicitProxyArgs =
        com.pulumi.azurenative.network.inputs.ExplicitProxyArgs.builder()
            .enableExplicitProxy(enableExplicitProxy?.applyValue({ args0 -> args0 }))
            .enablePacFile(enablePacFile?.applyValue({ args0 -> args0 }))
            .httpPort(httpPort?.applyValue({ args0 -> args0 }))
            .httpsPort(httpsPort?.applyValue({ args0 -> args0 }))
            .pacFile(pacFile?.applyValue({ args0 -> args0 }))
            .pacFilePort(pacFilePort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExplicitProxyArgs].
 */
@PulumiTagMarker
public class ExplicitProxyArgsBuilder internal constructor() {
    private var enableExplicitProxy: Output<Boolean>? = null

    private var enablePacFile: Output<Boolean>? = null

    private var httpPort: Output<Int>? = null

    private var httpsPort: Output<Int>? = null

    private var pacFile: Output<String>? = null

    private var pacFilePort: Output<Int>? = null

    /**
     * @param value When set to true, explicit proxy mode is enabled.
     */
    @JvmName("fgihdpnciwrcdoka")
    public suspend fun enableExplicitProxy(`value`: Output<Boolean>) {
        this.enableExplicitProxy = value
    }

    /**
     * @param value When set to true, pac file port and url needs to be provided.
     */
    @JvmName("xegpiebsrultsklc")
    public suspend fun enablePacFile(`value`: Output<Boolean>) {
        this.enablePacFile = value
    }

    /**
     * @param value Port number for explicit proxy http protocol, cannot be greater than 64000.
     */
    @JvmName("ijuiknxalnpjyvmh")
    public suspend fun httpPort(`value`: Output<Int>) {
        this.httpPort = value
    }

    /**
     * @param value Port number for explicit proxy https protocol, cannot be greater than 64000.
     */
    @JvmName("tdnvxityoqgyinfa")
    public suspend fun httpsPort(`value`: Output<Int>) {
        this.httpsPort = value
    }

    /**
     * @param value SAS URL for PAC file.
     */
    @JvmName("hsyarwudntmidclx")
    public suspend fun pacFile(`value`: Output<String>) {
        this.pacFile = value
    }

    /**
     * @param value Port number for firewall to serve PAC file.
     */
    @JvmName("erycofqftwneltyj")
    public suspend fun pacFilePort(`value`: Output<Int>) {
        this.pacFilePort = value
    }

    /**
     * @param value When set to true, explicit proxy mode is enabled.
     */
    @JvmName("simgocyqgknmtwud")
    public suspend fun enableExplicitProxy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableExplicitProxy = mapped
    }

    /**
     * @param value When set to true, pac file port and url needs to be provided.
     */
    @JvmName("peqmisldsnrvjxna")
    public suspend fun enablePacFile(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePacFile = mapped
    }

    /**
     * @param value Port number for explicit proxy http protocol, cannot be greater than 64000.
     */
    @JvmName("apfgeikdtjxenvey")
    public suspend fun httpPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPort = mapped
    }

    /**
     * @param value Port number for explicit proxy https protocol, cannot be greater than 64000.
     */
    @JvmName("mmuvgtiyfdkvlibv")
    public suspend fun httpsPort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsPort = mapped
    }

    /**
     * @param value SAS URL for PAC file.
     */
    @JvmName("tvwmguvjmtgpoesh")
    public suspend fun pacFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pacFile = mapped
    }

    /**
     * @param value Port number for firewall to serve PAC file.
     */
    @JvmName("tehysoymgrqbiuga")
    public suspend fun pacFilePort(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pacFilePort = mapped
    }

    internal fun build(): ExplicitProxyArgs = ExplicitProxyArgs(
        enableExplicitProxy = enableExplicitProxy,
        enablePacFile = enablePacFile,
        httpPort = httpPort,
        httpsPort = httpsPort,
        pacFile = pacFile,
        pacFilePort = pacFilePort,
    )
}
