@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteCircuitServiceProviderPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Contains ServiceProviderProperties in an ExpressRouteCircuit.
 * @property bandwidthInMbps The BandwidthInMbps.
 * @property peeringLocation The peering location.
 * @property serviceProviderName The serviceProviderName.
 */
public data class ExpressRouteCircuitServiceProviderPropertiesArgs(
    public val bandwidthInMbps: Output<Int>? = null,
    public val peeringLocation: Output<String>? = null,
    public val serviceProviderName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteCircuitServiceProviderPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.ExpressRouteCircuitServiceProviderPropertiesArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteCircuitServiceProviderPropertiesArgs.builder()
            .bandwidthInMbps(bandwidthInMbps?.applyValue({ args0 -> args0 }))
            .peeringLocation(peeringLocation?.applyValue({ args0 -> args0 }))
            .serviceProviderName(serviceProviderName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteCircuitServiceProviderPropertiesArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitServiceProviderPropertiesArgsBuilder internal constructor() {
    private var bandwidthInMbps: Output<Int>? = null

    private var peeringLocation: Output<String>? = null

    private var serviceProviderName: Output<String>? = null

    /**
     * @param value The BandwidthInMbps.
     */
    @JvmName("tlyraamrtashypfa")
    public suspend fun bandwidthInMbps(`value`: Output<Int>) {
        this.bandwidthInMbps = value
    }

    /**
     * @param value The peering location.
     */
    @JvmName("hmxhicgcrhkjflwq")
    public suspend fun peeringLocation(`value`: Output<String>) {
        this.peeringLocation = value
    }

    /**
     * @param value The serviceProviderName.
     */
    @JvmName("gomjgbctecestvuw")
    public suspend fun serviceProviderName(`value`: Output<String>) {
        this.serviceProviderName = value
    }

    /**
     * @param value The BandwidthInMbps.
     */
    @JvmName("bntmebyhxffjemvw")
    public suspend fun bandwidthInMbps(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthInMbps = mapped
    }

    /**
     * @param value The peering location.
     */
    @JvmName("kolwamwaicwtyhff")
    public suspend fun peeringLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peeringLocation = mapped
    }

    /**
     * @param value The serviceProviderName.
     */
    @JvmName("lqikjrgaxotjndha")
    public suspend fun serviceProviderName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceProviderName = mapped
    }

    internal fun build(): ExpressRouteCircuitServiceProviderPropertiesArgs =
        ExpressRouteCircuitServiceProviderPropertiesArgs(
            bandwidthInMbps = bandwidthInMbps,
            peeringLocation = peeringLocation,
            serviceProviderName = serviceProviderName,
        )
}
