@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleActionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyFilterRuleActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the FirewallPolicyFilterRuleAction.
 * @property type The type of action.
 */
public data class FirewallPolicyFilterRuleActionArgs(
    public val type: Output<Either<String, FirewallPolicyFilterRuleActionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleActionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleActionArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleActionArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyFilterRuleActionArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFilterRuleActionArgsBuilder internal constructor() {
    private var type: Output<Either<String, FirewallPolicyFilterRuleActionType>>? = null

    /**
     * @param value The type of action.
     */
    @JvmName("badumowfgursqddj")
    public suspend fun type(`value`: Output<Either<String, FirewallPolicyFilterRuleActionType>>) {
        this.type = value
    }

    /**
     * @param value The type of action.
     */
    @JvmName("wkusbptfalwsmrjt")
    public suspend fun type(`value`: Either<String, FirewallPolicyFilterRuleActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("ddvemucswauxeetf")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicyFilterRuleActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("dftvpebsaffxiogc")
    public fun type(`value`: FirewallPolicyFilterRuleActionType) {
        val toBeMapped = Either.ofRight<String, FirewallPolicyFilterRuleActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FirewallPolicyFilterRuleActionArgs = FirewallPolicyFilterRuleActionArgs(
        type = type,
    )
}
