@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Firewall Policy Filter Rule.
 * @property action The action type of a Filter rule.
 * @property name The name of the rule.
 * @property priority Priority of the Firewall Policy Rule resource.
 * @property ruleConditions Collection of rule conditions used by a rule.
 * @property ruleType The type of the rule.
 * Expected value is 'FirewallPolicyFilterRule'.
 */
public data class FirewallPolicyFilterRuleArgs(
    public val action: Output<FirewallPolicyFilterRuleActionArgs>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val ruleConditions: Output<List<Any>>? = null,
    public val ruleType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .ruleConditions(ruleConditions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ruleType(ruleType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicyFilterRuleArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFilterRuleArgsBuilder internal constructor() {
    private var action: Output<FirewallPolicyFilterRuleActionArgs>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var ruleConditions: Output<List<Any>>? = null

    private var ruleType: Output<String>? = null

    /**
     * @param value The action type of a Filter rule.
     */
    @JvmName("wnfnopwsocvfarqo")
    public suspend fun action(`value`: Output<FirewallPolicyFilterRuleActionArgs>) {
        this.action = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("urvfmgqdjqpoytgs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the Firewall Policy Rule resource.
     */
    @JvmName("cmatusyynnkpwdar")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Collection of rule conditions used by a rule.
     */
    @JvmName("akfwiwahprsasslj")
    public suspend fun ruleConditions(`value`: Output<List<Any>>) {
        this.ruleConditions = value
    }

    @JvmName("dghpmghoghvjtbeq")
    public suspend fun ruleConditions(vararg values: Output<Any>) {
        this.ruleConditions = Output.all(values.asList())
    }

    /**
     * @param values Collection of rule conditions used by a rule.
     */
    @JvmName("btrpvdvhngpbybco")
    public suspend fun ruleConditions(values: List<Output<Any>>) {
        this.ruleConditions = Output.all(values)
    }

    /**
     * @param value The type of the rule.
     * Expected value is 'FirewallPolicyFilterRule'.
     */
    @JvmName("owksdvjunrlontjj")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value The action type of a Filter rule.
     */
    @JvmName("nsgxsmjxgyvpscgy")
    public suspend fun action(`value`: FirewallPolicyFilterRuleActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action type of a Filter rule.
     */
    @JvmName("mrlarnjtxwovlbgh")
    public suspend
    fun action(argument: suspend FirewallPolicyFilterRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyFilterRuleActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("vgjksppkpmulwvlu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the Firewall Policy Rule resource.
     */
    @JvmName("meqwlngeqjulijua")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Collection of rule conditions used by a rule.
     */
    @JvmName("lauacnyiwiuomgin")
    public suspend fun ruleConditions(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleConditions = mapped
    }

    /**
     * @param values Collection of rule conditions used by a rule.
     */
    @JvmName("qxdnvndebyhsjmgg")
    public suspend fun ruleConditions(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleConditions = mapped
    }

    /**
     * @param value The type of the rule.
     * Expected value is 'FirewallPolicyFilterRule'.
     */
    @JvmName("ridpqnrxjwqjtoca")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    internal fun build(): FirewallPolicyFilterRuleArgs = FirewallPolicyFilterRuleArgs(
        action = action,
        name = name,
        priority = priority,
        ruleConditions = ruleConditions,
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
    )
}
