@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleCollectionActionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyFilterRuleCollectionActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the FirewallPolicyFilterRuleCollectionAction.
 * @property type The type of action.
 */
public data class FirewallPolicyFilterRuleCollectionActionArgs(
    public val type: Output<Either<String, FirewallPolicyFilterRuleCollectionActionType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleCollectionActionArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleCollectionActionArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleCollectionActionArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyFilterRuleCollectionActionArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFilterRuleCollectionActionArgsBuilder internal constructor() {
    private var type: Output<Either<String, FirewallPolicyFilterRuleCollectionActionType>>? = null

    /**
     * @param value The type of action.
     */
    @JvmName("epqrtmveqgtsbrgq")
    public suspend
    fun type(`value`: Output<Either<String, FirewallPolicyFilterRuleCollectionActionType>>) {
        this.type = value
    }

    /**
     * @param value The type of action.
     */
    @JvmName("mkslbwsbxvjgsaih")
    public suspend fun type(`value`: Either<String, FirewallPolicyFilterRuleCollectionActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("giwjqmynlbjskgiw")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicyFilterRuleCollectionActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("cacvfhucldjatpij")
    public fun type(`value`: FirewallPolicyFilterRuleCollectionActionType) {
        val toBeMapped = Either.ofRight<String, FirewallPolicyFilterRuleCollectionActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FirewallPolicyFilterRuleCollectionActionArgs =
        FirewallPolicyFilterRuleCollectionActionArgs(
            type = type,
        )
}
