@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyIntrusionDetectionStateType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Intrusion detection signatures specification states.
 * @property id Signature id.
 * @property mode The signature state.
 */
public data class FirewallPolicyIntrusionDetectionSignatureSpecificationArgs(
    public val id: Output<String>? = null,
    public val mode: Output<Either<String, FirewallPolicyIntrusionDetectionStateType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyIntrusionDetectionSignatureSpecificationArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyIntrusionDetectionSignatureSpecificationArgs].
 */
@PulumiTagMarker
public class FirewallPolicyIntrusionDetectionSignatureSpecificationArgsBuilder internal
constructor() {
    private var id: Output<String>? = null

    private var mode: Output<Either<String, FirewallPolicyIntrusionDetectionStateType>>? = null

    /**
     * @param value Signature id.
     */
    @JvmName("dyijroooqpvngnum")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The signature state.
     */
    @JvmName("ksgknxtlqcmunbpa")
    public suspend
    fun mode(`value`: Output<Either<String, FirewallPolicyIntrusionDetectionStateType>>) {
        this.mode = value
    }

    /**
     * @param value Signature id.
     */
    @JvmName("tlpknrerqqftxrgx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The signature state.
     */
    @JvmName("ymfpkftsvtgabpgq")
    public suspend fun mode(`value`: Either<String, FirewallPolicyIntrusionDetectionStateType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The signature state.
     */
    @JvmName("mvwtfxcwuwudvxct")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicyIntrusionDetectionStateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The signature state.
     */
    @JvmName("xcyfogxenwiobqbd")
    public fun mode(`value`: FirewallPolicyIntrusionDetectionStateType) {
        val toBeMapped = Either.ofRight<String, FirewallPolicyIntrusionDetectionStateType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): FirewallPolicyIntrusionDetectionSignatureSpecificationArgs =
        FirewallPolicyIntrusionDetectionSignatureSpecificationArgs(
            id = id,
            mode = mode,
        )
}
