@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleCollectionActionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyNatRuleCollectionActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the FirewallPolicyNatRuleCollectionAction.
 * @property type The type of action.
 */
public data class FirewallPolicyNatRuleCollectionActionArgs(
    public val type: Output<Either<String, FirewallPolicyNatRuleCollectionActionType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleCollectionActionArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleCollectionActionArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleCollectionActionArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyNatRuleCollectionActionArgs].
 */
@PulumiTagMarker
public class FirewallPolicyNatRuleCollectionActionArgsBuilder internal constructor() {
    private var type: Output<Either<String, FirewallPolicyNatRuleCollectionActionType>>? = null

    /**
     * @param value The type of action.
     */
    @JvmName("jffbbevkqpjeyvga")
    public suspend
    fun type(`value`: Output<Either<String, FirewallPolicyNatRuleCollectionActionType>>) {
        this.type = value
    }

    /**
     * @param value The type of action.
     */
    @JvmName("eegdjvsbftxxpchh")
    public suspend fun type(`value`: Either<String, FirewallPolicyNatRuleCollectionActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("hhnuumglqrmdrlri")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicyNatRuleCollectionActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("hvphkruuwvewrbcr")
    public fun type(`value`: FirewallPolicyNatRuleCollectionActionType) {
        val toBeMapped = Either.ofRight<String, FirewallPolicyNatRuleCollectionActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FirewallPolicyNatRuleCollectionActionArgs =
        FirewallPolicyNatRuleCollectionActionArgs(
            type = type,
        )
}
