@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleCollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Firewall Policy NAT Rule Collection.
 * @property action The action type of a Nat rule collection.
 * @property name The name of the rule collection.
 * @property priority Priority of the Firewall Policy Rule Collection resource.
 * @property ruleCollectionType The type of the rule collection.
 * Expected value is 'FirewallPolicyNatRuleCollection'.
 * @property rules List of rules included in a rule collection.
 */
public data class FirewallPolicyNatRuleCollectionArgs(
    public val action: Output<FirewallPolicyNatRuleCollectionActionArgs>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val ruleCollectionType: Output<String>,
    public val rules: Output<List<Any>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleCollectionArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleCollectionArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .ruleCollectionType(ruleCollectionType.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FirewallPolicyNatRuleCollectionArgs].
 */
@PulumiTagMarker
public class FirewallPolicyNatRuleCollectionArgsBuilder internal constructor() {
    private var action: Output<FirewallPolicyNatRuleCollectionActionArgs>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var ruleCollectionType: Output<String>? = null

    private var rules: Output<List<Any>>? = null

    /**
     * @param value The action type of a Nat rule collection.
     */
    @JvmName("ojafeewltcayomkw")
    public suspend fun action(`value`: Output<FirewallPolicyNatRuleCollectionActionArgs>) {
        this.action = value
    }

    /**
     * @param value The name of the rule collection.
     */
    @JvmName("ddtsnlsccotujplo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the Firewall Policy Rule Collection resource.
     */
    @JvmName("fbcuiupkmnluesdu")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The type of the rule collection.
     * Expected value is 'FirewallPolicyNatRuleCollection'.
     */
    @JvmName("ydkiknipddjlkleq")
    public suspend fun ruleCollectionType(`value`: Output<String>) {
        this.ruleCollectionType = value
    }

    /**
     * @param value List of rules included in a rule collection.
     */
    @JvmName("xjafvhnythxotemv")
    public suspend fun rules(`value`: Output<List<Any>>) {
        this.rules = value
    }

    @JvmName("dogtoklbbbsacxxp")
    public suspend fun rules(vararg values: Output<Any>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of rules included in a rule collection.
     */
    @JvmName("qdbyybyweavmfppc")
    public suspend fun rules(values: List<Output<Any>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The action type of a Nat rule collection.
     */
    @JvmName("ojotgjhbsfdblwco")
    public suspend fun action(`value`: FirewallPolicyNatRuleCollectionActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action type of a Nat rule collection.
     */
    @JvmName("wwsglqtcmfnyanrt")
    public suspend
    fun action(argument: suspend FirewallPolicyNatRuleCollectionActionArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyNatRuleCollectionActionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value The name of the rule collection.
     */
    @JvmName("rvjdwtjolxojecyn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the Firewall Policy Rule Collection resource.
     */
    @JvmName("wwxxwdfukfyglgrx")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The type of the rule collection.
     * Expected value is 'FirewallPolicyNatRuleCollection'.
     */
    @JvmName("bmjupxqprteiprem")
    public suspend fun ruleCollectionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleCollectionType = mapped
    }

    /**
     * @param value List of rules included in a rule collection.
     */
    @JvmName("ppsjqggqimgbfwlm")
    public suspend fun rules(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param values List of rules included in a rule collection.
     */
    @JvmName("icwclwafkkogfkvq")
    public suspend fun rules(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): FirewallPolicyNatRuleCollectionArgs = FirewallPolicyNatRuleCollectionArgs(
        action = action,
        name = name,
        priority = priority,
        ruleCollectionType = ruleCollectionType ?: throw PulumiNullFieldException("ruleCollectionType"),
        rules = rules,
    )
}
