@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyTransportSecurityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Configuration needed to perform TLS termination & initiation.
 * @property certificateAuthority The CA used for intermediate CA generation.
 */
public data class FirewallPolicyTransportSecurityArgs(
    public val certificateAuthority: Output<FirewallPolicyCertificateAuthorityArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyTransportSecurityArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyTransportSecurityArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyTransportSecurityArgs.builder()
            .certificateAuthority(
                certificateAuthority?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyTransportSecurityArgs].
 */
@PulumiTagMarker
public class FirewallPolicyTransportSecurityArgsBuilder internal constructor() {
    private var certificateAuthority: Output<FirewallPolicyCertificateAuthorityArgs>? = null

    /**
     * @param value The CA used for intermediate CA generation.
     */
    @JvmName("rejgapjtqgyqilne")
    public suspend fun certificateAuthority(`value`: Output<FirewallPolicyCertificateAuthorityArgs>) {
        this.certificateAuthority = value
    }

    /**
     * @param value The CA used for intermediate CA generation.
     */
    @JvmName("auohbfapjfbpxati")
    public suspend fun certificateAuthority(`value`: FirewallPolicyCertificateAuthorityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateAuthority = mapped
    }

    /**
     * @param argument The CA used for intermediate CA generation.
     */
    @JvmName("uqaajtlljafphscw")
    public suspend
    fun certificateAuthority(argument: suspend FirewallPolicyCertificateAuthorityArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyCertificateAuthorityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.certificateAuthority = mapped
    }

    internal fun build(): FirewallPolicyTransportSecurityArgs = FirewallPolicyTransportSecurityArgs(
        certificateAuthority = certificateAuthority,
    )
}
