@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FrontDoorPolicySettingsArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.PolicyEnabledState
import com.pulumi.azurenative.network.kotlin.enums.PolicyMode
import com.pulumi.azurenative.network.kotlin.enums.PolicyRequestBodyCheck
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines top-level WebApplicationFirewallPolicy configuration settings.
 * @property customBlockResponseBody If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
 * @property customBlockResponseStatusCode If the action type is block, customer can override the response status code.
 * @property enabledState Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
 * @property mode Describes if it is in detection mode or prevention mode at policy level.
 * @property redirectUrl If action type is redirect, this field represents redirect URL for the client.
 * @property requestBodyCheck Describes if policy managed rules will inspect the request body content.
 */
public data class FrontDoorPolicySettingsArgs(
    public val customBlockResponseBody: Output<String>? = null,
    public val customBlockResponseStatusCode: Output<Int>? = null,
    public val enabledState: Output<Either<String, PolicyEnabledState>>? = null,
    public val mode: Output<Either<String, PolicyMode>>? = null,
    public val redirectUrl: Output<String>? = null,
    public val requestBodyCheck: Output<Either<String, PolicyRequestBodyCheck>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FrontDoorPolicySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FrontDoorPolicySettingsArgs =
        com.pulumi.azurenative.network.inputs.FrontDoorPolicySettingsArgs.builder()
            .customBlockResponseBody(customBlockResponseBody?.applyValue({ args0 -> args0 }))
            .customBlockResponseStatusCode(customBlockResponseStatusCode?.applyValue({ args0 -> args0 }))
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .redirectUrl(redirectUrl?.applyValue({ args0 -> args0 }))
            .requestBodyCheck(
                requestBodyCheck?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [FrontDoorPolicySettingsArgs].
 */
@PulumiTagMarker
public class FrontDoorPolicySettingsArgsBuilder internal constructor() {
    private var customBlockResponseBody: Output<String>? = null

    private var customBlockResponseStatusCode: Output<Int>? = null

    private var enabledState: Output<Either<String, PolicyEnabledState>>? = null

    private var mode: Output<Either<String, PolicyMode>>? = null

    private var redirectUrl: Output<String>? = null

    private var requestBodyCheck: Output<Either<String, PolicyRequestBodyCheck>>? = null

    /**
     * @param value If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
     */
    @JvmName("yyxdcmdudxmubfbr")
    public suspend fun customBlockResponseBody(`value`: Output<String>) {
        this.customBlockResponseBody = value
    }

    /**
     * @param value If the action type is block, customer can override the response status code.
     */
    @JvmName("owcqbkxlmmifblry")
    public suspend fun customBlockResponseStatusCode(`value`: Output<Int>) {
        this.customBlockResponseStatusCode = value
    }

    /**
     * @param value Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("ufbtbygsduwhploa")
    public suspend fun enabledState(`value`: Output<Either<String, PolicyEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value Describes if it is in detection mode or prevention mode at policy level.
     */
    @JvmName("asxuvxaitqnhbrks")
    public suspend fun mode(`value`: Output<Either<String, PolicyMode>>) {
        this.mode = value
    }

    /**
     * @param value If action type is redirect, this field represents redirect URL for the client.
     */
    @JvmName("fscegsajdslwonyv")
    public suspend fun redirectUrl(`value`: Output<String>) {
        this.redirectUrl = value
    }

    /**
     * @param value Describes if policy managed rules will inspect the request body content.
     */
    @JvmName("osrpsegqhltjyuud")
    public suspend fun requestBodyCheck(`value`: Output<Either<String, PolicyRequestBodyCheck>>) {
        this.requestBodyCheck = value
    }

    /**
     * @param value If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
     */
    @JvmName("hoejefnkgqquimvw")
    public suspend fun customBlockResponseBody(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customBlockResponseBody = mapped
    }

    /**
     * @param value If the action type is block, customer can override the response status code.
     */
    @JvmName("qeojfoqmpvmppydk")
    public suspend fun customBlockResponseStatusCode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customBlockResponseStatusCode = mapped
    }

    /**
     * @param value Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("xgnajinwrmeknckg")
    public suspend fun enabledState(`value`: Either<String, PolicyEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("wgnopwufmwheajvd")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the policy is in enabled or disabled state. Defaults to Enabled if not specified.
     */
    @JvmName("wgglnurcsvwwjqsk")
    public fun enabledState(`value`: PolicyEnabledState) {
        val toBeMapped = Either.ofRight<String, PolicyEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if it is in detection mode or prevention mode at policy level.
     */
    @JvmName("hvklmsrlqhmhcsdl")
    public suspend fun mode(`value`: Either<String, PolicyMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Describes if it is in detection mode or prevention mode at policy level.
     */
    @JvmName("ffynrbteedeiydvs")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Describes if it is in detection mode or prevention mode at policy level.
     */
    @JvmName("oijhqpwiyfrfbpju")
    public fun mode(`value`: PolicyMode) {
        val toBeMapped = Either.ofRight<String, PolicyMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value If action type is redirect, this field represents redirect URL for the client.
     */
    @JvmName("lmyfqvxjqdalvjgn")
    public suspend fun redirectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectUrl = mapped
    }

    /**
     * @param value Describes if policy managed rules will inspect the request body content.
     */
    @JvmName("beaextmlkwlonebd")
    public suspend fun requestBodyCheck(`value`: Either<String, PolicyRequestBodyCheck>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBodyCheck = mapped
    }

    /**
     * @param value Describes if policy managed rules will inspect the request body content.
     */
    @JvmName("btkmriowpnodidrj")
    public fun requestBodyCheck(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyRequestBodyCheck>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestBodyCheck = mapped
    }

    /**
     * @param value Describes if policy managed rules will inspect the request body content.
     */
    @JvmName("yqvjphatebfamvef")
    public fun requestBodyCheck(`value`: PolicyRequestBodyCheck) {
        val toBeMapped = Either.ofRight<String, PolicyRequestBodyCheck>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.requestBodyCheck = mapped
    }

    internal fun build(): FrontDoorPolicySettingsArgs = FrontDoorPolicySettingsArgs(
        customBlockResponseBody = customBlockResponseBody,
        customBlockResponseStatusCode = customBlockResponseStatusCode,
        enabledState = enabledState,
        mode = mode,
        redirectUrl = redirectUrl,
        requestBodyCheck = requestBodyCheck,
    )
}
