@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GatewayCustomBgpIpAddressIpConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * GatewayCustomBgpIpAddressIpConfiguration for a virtual network gateway connection.
 * @property customBgpIpAddress The custom BgpPeeringAddress which belongs to IpconfigurationId.
 * @property ipConfigurationId The IpconfigurationId of ipconfiguration which belongs to gateway.
 */
public data class GatewayCustomBgpIpAddressIpConfigurationArgs(
    public val customBgpIpAddress: Output<String>,
    public val ipConfigurationId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GatewayCustomBgpIpAddressIpConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GatewayCustomBgpIpAddressIpConfigurationArgs =
        com.pulumi.azurenative.network.inputs.GatewayCustomBgpIpAddressIpConfigurationArgs.builder()
            .customBgpIpAddress(customBgpIpAddress.applyValue({ args0 -> args0 }))
            .ipConfigurationId(ipConfigurationId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayCustomBgpIpAddressIpConfigurationArgs].
 */
@PulumiTagMarker
public class GatewayCustomBgpIpAddressIpConfigurationArgsBuilder internal constructor() {
    private var customBgpIpAddress: Output<String>? = null

    private var ipConfigurationId: Output<String>? = null

    /**
     * @param value The custom BgpPeeringAddress which belongs to IpconfigurationId.
     */
    @JvmName("rfbkalesbxnyroae")
    public suspend fun customBgpIpAddress(`value`: Output<String>) {
        this.customBgpIpAddress = value
    }

    /**
     * @param value The IpconfigurationId of ipconfiguration which belongs to gateway.
     */
    @JvmName("xkmuwjrsincdyaee")
    public suspend fun ipConfigurationId(`value`: Output<String>) {
        this.ipConfigurationId = value
    }

    /**
     * @param value The custom BgpPeeringAddress which belongs to IpconfigurationId.
     */
    @JvmName("rdjahyppwgcjraui")
    public suspend fun customBgpIpAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customBgpIpAddress = mapped
    }

    /**
     * @param value The IpconfigurationId of ipconfiguration which belongs to gateway.
     */
    @JvmName("tpgmlqmjapstscwd")
    public suspend fun ipConfigurationId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurationId = mapped
    }

    internal fun build(): GatewayCustomBgpIpAddressIpConfigurationArgs =
        GatewayCustomBgpIpAddressIpConfigurationArgs(
            customBgpIpAddress = customBgpIpAddress ?: throw PulumiNullFieldException("customBgpIpAddress"),
            ipConfigurationId = ipConfigurationId ?: throw PulumiNullFieldException("ipConfigurationId"),
        )
}
