@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetBastionHostPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bastionHostName The name of the Bastion Host.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetBastionHostPlainArgs(
    public val bastionHostName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetBastionHostPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetBastionHostPlainArgs =
        com.pulumi.azurenative.network.inputs.GetBastionHostPlainArgs.builder()
            .bastionHostName(bastionHostName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBastionHostPlainArgs].
 */
@PulumiTagMarker
public class GetBastionHostPlainArgsBuilder internal constructor() {
    private var bastionHostName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Bastion Host.
     */
    @JvmName("reesyyuhpgkmjjsa")
    public suspend fun bastionHostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bastionHostName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("rmjupgkdnujnpncv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBastionHostPlainArgs = GetBastionHostPlainArgs(
        bastionHostName = bastionHostName ?: throw PulumiNullFieldException("bastionHostName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
