@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetDscpConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dscpConfigurationName The name of the resource.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetDscpConfigurationPlainArgs(
    public val dscpConfigurationName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetDscpConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetDscpConfigurationPlainArgs =
        com.pulumi.azurenative.network.inputs.GetDscpConfigurationPlainArgs.builder()
            .dscpConfigurationName(dscpConfigurationName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDscpConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetDscpConfigurationPlainArgsBuilder internal constructor() {
    private var dscpConfigurationName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the resource.
     */
    @JvmName("voesabjeyigfgipb")
    public suspend fun dscpConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dscpConfigurationName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ucbadefnauqcicny")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDscpConfigurationPlainArgs = GetDscpConfigurationPlainArgs(
        dscpConfigurationName = dscpConfigurationName ?: throw
            PulumiNullFieldException("dscpConfigurationName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
