@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetExpressRoutePortPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expressRoutePortName The name of ExpressRoutePort.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetExpressRoutePortPlainArgs(
    public val expressRoutePortName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetExpressRoutePortPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetExpressRoutePortPlainArgs =
        com.pulumi.azurenative.network.inputs.GetExpressRoutePortPlainArgs.builder()
            .expressRoutePortName(expressRoutePortName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExpressRoutePortPlainArgs].
 */
@PulumiTagMarker
public class GetExpressRoutePortPlainArgsBuilder internal constructor() {
    private var expressRoutePortName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of ExpressRoutePort.
     */
    @JvmName("quilvxwhaycglaxg")
    public suspend fun expressRoutePortName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.expressRoutePortName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dyblumgykxfnbnln")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExpressRoutePortPlainArgs = GetExpressRoutePortPlainArgs(
        expressRoutePortName = expressRoutePortName ?: throw
            PulumiNullFieldException("expressRoutePortName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
