@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetLoadBalancerBackendAddressPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property backendAddressPoolName The name of the backend address pool.
 * @property loadBalancerName The name of the load balancer.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetLoadBalancerBackendAddressPoolPlainArgs(
    public val backendAddressPoolName: String,
    public val loadBalancerName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetLoadBalancerBackendAddressPoolPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetLoadBalancerBackendAddressPoolPlainArgs =
        com.pulumi.azurenative.network.inputs.GetLoadBalancerBackendAddressPoolPlainArgs.builder()
            .backendAddressPoolName(backendAddressPoolName.let({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLoadBalancerBackendAddressPoolPlainArgs].
 */
@PulumiTagMarker
public class GetLoadBalancerBackendAddressPoolPlainArgsBuilder internal constructor() {
    private var backendAddressPoolName: String? = null

    private var loadBalancerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the backend address pool.
     */
    @JvmName("cbcpclokvlcfthdc")
    public suspend fun backendAddressPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.backendAddressPoolName = mapped
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("cncavicqoqjgujin")
    public suspend fun loadBalancerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dwfqpojofevenwec")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLoadBalancerBackendAddressPoolPlainArgs =
        GetLoadBalancerBackendAddressPoolPlainArgs(
            backendAddressPoolName = backendAddressPoolName ?: throw
                PulumiNullFieldException("backendAddressPoolName"),
            loadBalancerName = loadBalancerName ?: throw PulumiNullFieldException("loadBalancerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
