@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetManagementGroupNetworkManagerConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupId The management group Id which uniquely identify the Microsoft Azure management group.
 * @property networkManagerConnectionName Name for the network manager connection.
 */
public data class GetManagementGroupNetworkManagerConnectionPlainArgs(
    public val managementGroupId: String,
    public val networkManagerConnectionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetManagementGroupNetworkManagerConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetManagementGroupNetworkManagerConnectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetManagementGroupNetworkManagerConnectionPlainArgs.builder()
            .managementGroupId(managementGroupId.let({ args0 -> args0 }))
            .networkManagerConnectionName(networkManagerConnectionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementGroupNetworkManagerConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetManagementGroupNetworkManagerConnectionPlainArgsBuilder internal constructor() {
    private var managementGroupId: String? = null

    private var networkManagerConnectionName: String? = null

    /**
     * @param value The management group Id which uniquely identify the Microsoft Azure management group.
     */
    @JvmName("hjhsfnjkfgetqtdx")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    /**
     * @param value Name for the network manager connection.
     */
    @JvmName("fckiyomsprvmfrmm")
    public suspend fun networkManagerConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerConnectionName = mapped
    }

    internal fun build(): GetManagementGroupNetworkManagerConnectionPlainArgs =
        GetManagementGroupNetworkManagerConnectionPlainArgs(
            managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
            networkManagerConnectionName = networkManagerConnectionName ?: throw
                PulumiNullFieldException("networkManagerConnectionName"),
        )
}
