@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNetworkSecurityPerimeterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkSecurityPerimeterName The name of the network security perimeter.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNetworkSecurityPerimeterPlainArgs(
    public val networkSecurityPerimeterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNetworkSecurityPerimeterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNetworkSecurityPerimeterPlainArgs =
        com.pulumi.azurenative.network.inputs.GetNetworkSecurityPerimeterPlainArgs.builder()
            .networkSecurityPerimeterName(networkSecurityPerimeterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkSecurityPerimeterPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkSecurityPerimeterPlainArgsBuilder internal constructor() {
    private var networkSecurityPerimeterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("qtsnkhdhphtiauhc")
    public suspend fun networkSecurityPerimeterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkSecurityPerimeterName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tlhsereuepfhnuyq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkSecurityPerimeterPlainArgs = GetNetworkSecurityPerimeterPlainArgs(
        networkSecurityPerimeterName = networkSecurityPerimeterName ?: throw
            PulumiNullFieldException("networkSecurityPerimeterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
