@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayP2sVpnConnectionHealthDetailedPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property gatewayName The name of the P2SVpnGateway.
 * @property outputBlobSasUrl The sas-url to download the P2S Vpn connection health detail.
 * @property resourceGroupName The name of the resource group.
 * @property vpnUserNamesFilter The list of p2s vpn user names whose p2s vpn connection detailed health to retrieve for.
 */
public data class GetP2sVpnGatewayP2sVpnConnectionHealthDetailedPlainArgs(
    public val gatewayName: String,
    public val outputBlobSasUrl: String? = null,
    public val resourceGroupName: String,
    public val vpnUserNamesFilter: List<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayP2sVpnConnectionHealthDetailedPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayP2sVpnConnectionHealthDetailedPlainArgs =
        com.pulumi.azurenative.network.inputs.GetP2sVpnGatewayP2sVpnConnectionHealthDetailedPlainArgs.builder()
            .gatewayName(gatewayName.let({ args0 -> args0 }))
            .outputBlobSasUrl(outputBlobSasUrl?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vpnUserNamesFilter(vpnUserNamesFilter?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetP2sVpnGatewayP2sVpnConnectionHealthDetailedPlainArgs].
 */
@PulumiTagMarker
public class GetP2sVpnGatewayP2sVpnConnectionHealthDetailedPlainArgsBuilder internal constructor() {
    private var gatewayName: String? = null

    private var outputBlobSasUrl: String? = null

    private var resourceGroupName: String? = null

    private var vpnUserNamesFilter: List<String>? = null

    /**
     * @param value The name of the P2SVpnGateway.
     */
    @JvmName("afppvvhvvyrwphun")
    public suspend fun gatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value The sas-url to download the P2S Vpn connection health detail.
     */
    @JvmName("ayppkxuhnmowelgu")
    public suspend fun outputBlobSasUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputBlobSasUrl = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qkhpfxnbghemkjiu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The list of p2s vpn user names whose p2s vpn connection detailed health to retrieve for.
     */
    @JvmName("cqewvudtumqkhmuf")
    public suspend fun vpnUserNamesFilter(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpnUserNamesFilter = mapped
    }

    /**
     * @param values The list of p2s vpn user names whose p2s vpn connection detailed health to retrieve for.
     */
    @JvmName("sobnycaohyoxuiny")
    public suspend fun vpnUserNamesFilter(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vpnUserNamesFilter = mapped
    }

    internal fun build(): GetP2sVpnGatewayP2sVpnConnectionHealthDetailedPlainArgs =
        GetP2sVpnGatewayP2sVpnConnectionHealthDetailedPlainArgs(
            gatewayName = gatewayName ?: throw PulumiNullFieldException("gatewayName"),
            outputBlobSasUrl = outputBlobSasUrl,
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vpnUserNamesFilter = vpnUserNamesFilter,
        )
}
