@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetPacketCapturePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkWatcherName The name of the network watcher.
 * @property packetCaptureName The name of the packet capture session.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPacketCapturePlainArgs(
    public val networkWatcherName: String,
    public val packetCaptureName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetPacketCapturePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetPacketCapturePlainArgs =
        com.pulumi.azurenative.network.inputs.GetPacketCapturePlainArgs.builder()
            .networkWatcherName(networkWatcherName.let({ args0 -> args0 }))
            .packetCaptureName(packetCaptureName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPacketCapturePlainArgs].
 */
@PulumiTagMarker
public class GetPacketCapturePlainArgsBuilder internal constructor() {
    private var networkWatcherName: String? = null

    private var packetCaptureName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network watcher.
     */
    @JvmName("kfoeovggcbdxbmgi")
    public suspend fun networkWatcherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkWatcherName = mapped
    }

    /**
     * @param value The name of the packet capture session.
     */
    @JvmName("mmlrvbhibroprplq")
    public suspend fun packetCaptureName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.packetCaptureName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nehpruqvnfuejrkh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPacketCapturePlainArgs = GetPacketCapturePlainArgs(
        networkWatcherName = networkWatcherName ?: throw PulumiNullFieldException("networkWatcherName"),
        packetCaptureName = packetCaptureName ?: throw PulumiNullFieldException("packetCaptureName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
