@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetPublicIPAddressPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property publicIpAddressName The name of the public IP address.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPublicIPAddressPlainArgs(
    public val expand: String? = null,
    public val publicIpAddressName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetPublicIPAddressPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetPublicIPAddressPlainArgs =
        com.pulumi.azurenative.network.inputs.GetPublicIPAddressPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .publicIpAddressName(publicIpAddressName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPublicIPAddressPlainArgs].
 */
@PulumiTagMarker
public class GetPublicIPAddressPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var publicIpAddressName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("rydgfvtdrumaesoo")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the public IP address.
     */
    @JvmName("kjqrdldnkkserbgj")
    public suspend fun publicIpAddressName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publicIpAddressName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ycagtjajhoswnrul")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPublicIPAddressPlainArgs = GetPublicIPAddressPlainArgs(
        expand = expand,
        publicIpAddressName = publicIpAddressName ?: throw PulumiNullFieldException("publicIpAddressName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
