@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetPublicIPPrefixPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property publicIpPrefixName The name of the public IP prefix.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPublicIPPrefixPlainArgs(
    public val expand: String? = null,
    public val publicIpPrefixName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetPublicIPPrefixPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetPublicIPPrefixPlainArgs =
        com.pulumi.azurenative.network.inputs.GetPublicIPPrefixPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .publicIpPrefixName(publicIpPrefixName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPublicIPPrefixPlainArgs].
 */
@PulumiTagMarker
public class GetPublicIPPrefixPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var publicIpPrefixName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("svnuqltdnelyuaml")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the public IP prefix.
     */
    @JvmName("ivlkihtgiudkehfq")
    public suspend fun publicIpPrefixName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.publicIpPrefixName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("knastqjwcyhrdrin")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPublicIPPrefixPlainArgs = GetPublicIPPrefixPlainArgs(
        expand = expand,
        publicIpPrefixName = publicIpPrefixName ?: throw PulumiNullFieldException("publicIpPrefixName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
