@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetRouteFilterRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property routeFilterName The name of the route filter.
 * @property ruleName The name of the rule.
 */
public data class GetRouteFilterRulePlainArgs(
    public val resourceGroupName: String,
    public val routeFilterName: String,
    public val ruleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetRouteFilterRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetRouteFilterRulePlainArgs =
        com.pulumi.azurenative.network.inputs.GetRouteFilterRulePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .routeFilterName(routeFilterName.let({ args0 -> args0 }))
            .ruleName(ruleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteFilterRulePlainArgs].
 */
@PulumiTagMarker
public class GetRouteFilterRulePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var routeFilterName: String? = null

    private var ruleName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gsohoyevblyqxskq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the route filter.
     */
    @JvmName("igoiodywddcaspjj")
    public suspend fun routeFilterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeFilterName = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("ywbhuicdoxcfpwtr")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleName = mapped
    }

    internal fun build(): GetRouteFilterRulePlainArgs = GetRouteFilterRulePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        routeFilterName = routeFilterName ?: throw PulumiNullFieldException("routeFilterName"),
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
    )
}
