@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayNatRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property natRuleName The name of the nat rule.
 * @property resourceGroupName The resource group name of the Virtual Network Gateway.
 * @property virtualNetworkGatewayName The name of the gateway.
 */
public data class GetVirtualNetworkGatewayNatRulePlainArgs(
    public val natRuleName: String,
    public val resourceGroupName: String,
    public val virtualNetworkGatewayName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayNatRulePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayNatRulePlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayNatRulePlainArgs.builder()
            .natRuleName(natRuleName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkGatewayName(virtualNetworkGatewayName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkGatewayNatRulePlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkGatewayNatRulePlainArgsBuilder internal constructor() {
    private var natRuleName: String? = null

    private var resourceGroupName: String? = null

    private var virtualNetworkGatewayName: String? = null

    /**
     * @param value The name of the nat rule.
     */
    @JvmName("essdcljlhlqrrvhg")
    public suspend fun natRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.natRuleName = mapped
    }

    /**
     * @param value The resource group name of the Virtual Network Gateway.
     */
    @JvmName("xufviforehmwtojf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("arejruebcohemgns")
    public suspend fun virtualNetworkGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkGatewayName = mapped
    }

    internal fun build(): GetVirtualNetworkGatewayNatRulePlainArgs =
        GetVirtualNetworkGatewayNatRulePlainArgs(
            natRuleName = natRuleName ?: throw PulumiNullFieldException("natRuleName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            virtualNetworkGatewayName = virtualNetworkGatewayName ?: throw
                PulumiNullFieldException("virtualNetworkGatewayName"),
        )
}
