@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property virtualNetworkGatewayName The name of the virtual network gateway.
 */
public data class GetVirtualNetworkGatewayPlainArgs(
    public val resourceGroupName: String,
    public val virtualNetworkGatewayName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualNetworkGatewayPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualNetworkGatewayName(virtualNetworkGatewayName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualNetworkGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualNetworkGatewayPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var virtualNetworkGatewayName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wmwjndihturvrgjm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual network gateway.
     */
    @JvmName("pcjgekfskiuhhjab")
    public suspend fun virtualNetworkGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualNetworkGatewayName = mapped
    }

    internal fun build(): GetVirtualNetworkGatewayPlainArgs = GetVirtualNetworkGatewayPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualNetworkGatewayName = virtualNetworkGatewayName ?: throw
            PulumiNullFieldException("virtualNetworkGatewayName"),
    )
}
