@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVirtualRouterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property resourceGroupName The name of the resource group.
 * @property virtualRouterName The name of the Virtual Router.
 */
public data class GetVirtualRouterPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val virtualRouterName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVirtualRouterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVirtualRouterPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVirtualRouterPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .virtualRouterName(virtualRouterName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVirtualRouterPlainArgs].
 */
@PulumiTagMarker
public class GetVirtualRouterPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var virtualRouterName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("ptjcivwnpwemkrwm")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("thspdtbgnnlvtubl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Virtual Router.
     */
    @JvmName("lbooibpwgbvihaql")
    public suspend fun virtualRouterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualRouterName = mapped
    }

    internal fun build(): GetVirtualRouterPlainArgs = GetVirtualRouterPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        virtualRouterName = virtualRouterName ?: throw PulumiNullFieldException("virtualRouterName"),
    )
}
