@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetVpnConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionName The name of the vpn connection.
 * @property gatewayName The name of the gateway.
 * @property resourceGroupName The resource group name of the VpnGateway.
 */
public data class GetVpnConnectionPlainArgs(
    public val connectionName: String,
    public val gatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetVpnConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetVpnConnectionPlainArgs =
        com.pulumi.azurenative.network.inputs.GetVpnConnectionPlainArgs.builder()
            .connectionName(connectionName.let({ args0 -> args0 }))
            .gatewayName(gatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVpnConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetVpnConnectionPlainArgsBuilder internal constructor() {
    private var connectionName: String? = null

    private var gatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the vpn connection.
     */
    @JvmName("ffsvawrptwdfrvhp")
    public suspend fun connectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.connectionName = mapped
    }

    /**
     * @param value The name of the gateway.
     */
    @JvmName("rnbkjmwkfqfdffwb")
    public suspend fun gatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayName = mapped
    }

    /**
     * @param value The resource group name of the VpnGateway.
     */
    @JvmName("fohnhidmrspqrguk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetVpnConnectionPlainArgs = GetVpnConnectionPlainArgs(
        connectionName = connectionName ?: throw PulumiNullFieldException("connectionName"),
        gatewayName = gatewayName ?: throw PulumiNullFieldException("gatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
