@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GroupByUserSessionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Define user session identifier group by clauses.
 * @property groupByVariables List of group by clause variables.
 */
public data class GroupByUserSessionArgs(
    public val groupByVariables: Output<List<GroupByVariableArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GroupByUserSessionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GroupByUserSessionArgs =
        com.pulumi.azurenative.network.inputs.GroupByUserSessionArgs.builder()
            .groupByVariables(
                groupByVariables.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GroupByUserSessionArgs].
 */
@PulumiTagMarker
public class GroupByUserSessionArgsBuilder internal constructor() {
    private var groupByVariables: Output<List<GroupByVariableArgs>>? = null

    /**
     * @param value List of group by clause variables.
     */
    @JvmName("utihrllwxwgbiqmu")
    public suspend fun groupByVariables(`value`: Output<List<GroupByVariableArgs>>) {
        this.groupByVariables = value
    }

    @JvmName("xybrcauhllewmcrj")
    public suspend fun groupByVariables(vararg values: Output<GroupByVariableArgs>) {
        this.groupByVariables = Output.all(values.asList())
    }

    /**
     * @param values List of group by clause variables.
     */
    @JvmName("htsjoyihhbdaubhs")
    public suspend fun groupByVariables(values: List<Output<GroupByVariableArgs>>) {
        this.groupByVariables = Output.all(values)
    }

    /**
     * @param value List of group by clause variables.
     */
    @JvmName("rnuxqpjeudlkvfgf")
    public suspend fun groupByVariables(`value`: List<GroupByVariableArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupByVariables = mapped
    }

    /**
     * @param argument List of group by clause variables.
     */
    @JvmName("wejvjgbokxhstbeh")
    public suspend
    fun groupByVariables(argument: List<suspend GroupByVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GroupByVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.groupByVariables = mapped
    }

    /**
     * @param argument List of group by clause variables.
     */
    @JvmName("ndpshndbkecknusa")
    public suspend fun groupByVariables(
        vararg
        argument: suspend GroupByVariableArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            GroupByVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.groupByVariables = mapped
    }

    /**
     * @param argument List of group by clause variables.
     */
    @JvmName("ysnhightigmmhpma")
    public suspend fun groupByVariables(argument: suspend GroupByVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GroupByVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.groupByVariables = mapped
    }

    /**
     * @param values List of group by clause variables.
     */
    @JvmName("dhivgyxwvotutqlp")
    public suspend fun groupByVariables(vararg values: GroupByVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupByVariables = mapped
    }

    internal fun build(): GroupByUserSessionArgs = GroupByUserSessionArgs(
        groupByVariables = groupByVariables ?: throw PulumiNullFieldException("groupByVariables"),
    )
}
